/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NonCatalogedVersionHelperFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmContentProxyFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmProxyComponentMaintenanceFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmRecipeSupport;
import com.sonatype.nexus.repository.npm.internal.NpmAuditBulkHandler;
import com.sonatype.nexus.repository.npm.internal.NpmAuditErrorHandler;
import com.sonatype.nexus.repository.npm.internal.NpmAuditFacet;
import com.sonatype.nexus.repository.npm.internal.NpmAuditHandler;
import com.sonatype.nexus.repository.npm.internal.NpmAuditQuickHandler;
import com.sonatype.nexus.repository.npm.internal.NpmAuditTarballFacet;
import com.sonatype.nexus.repository.npm.internal.NpmHandlers;
import com.sonatype.nexus.repository.npm.internal.NpmNegativeCacheHandler;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.NpmPingHandler;
import com.sonatype.nexus.repository.npm.internal.NpmProxyCacheInvalidatorFacetImpl;
import com.sonatype.nexus.repository.npm.internal.NpmProxyFacet;
import com.sonatype.nexus.repository.npm.internal.NpmProxyHandler;
import com.sonatype.nexus.repository.npm.internal.NpmQuarantinedVersionFacet;
import com.sonatype.nexus.repository.npm.internal.NpmSecurityFacet;
import com.sonatype.nexus.repository.npm.internal.NpmTokenFacet;
import com.sonatype.nexus.repository.npm.internal.NpmWhoamiHandler;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacetProxy;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacetProxy;
import com.sonatype.nexus.repository.npm.repair.datastore.NpmRepairComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.purge.PurgeUnusedFacet;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.IndexHtmlForwardHandler;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;

@Named(value="npm-proxy")
@Singleton
public class NpmProxyRecipe
extends NpmRecipeSupport {
    public static final String NAME = "npm-proxy";
    private final Provider<HttpClientFacet> httpClientFacet;
    private final Provider<NegativeCacheFacet> negativeCacheFacet;
    private final Provider<NpmContentProxyFacet> proxyFacet;
    private final Provider<NpmSearchIndexFacetProxy> npmSearchIndexFacetProxy;
    private final Provider<NpmSearchFacetProxy> npmSearchFacet;
    private final Provider<PurgeUnusedFacet> purgeUnusedFacet;
    private final Provider<NpmProxyCacheInvalidatorFacetImpl> npmProxyCacheInvalidatorFacet;
    private final Provider<NonCatalogedVersionHelperFacet> nonCatalogedVersionHelperFacetProvider;
    private final Provider<NpmProxyComponentMaintenanceFacet> npmProxyComponentMaintenanceFacet;
    private final NpmNegativeCacheHandler negativeCacheHandler;
    private final NpmAuditQuickHandler auditQuickHandler;
    private final NpmAuditBulkHandler auditBulkHandler;
    private final NpmAuditHandler auditHandler;
    private final NpmProxyHandler proxyHandler;
    private final Provider<NpmQuarantinedVersionFacet> npmQuarantinedVersionFacetProvider;

    @Inject
    protected NpmProxyRecipe(@Named(value="proxy") Type type, @Named(value="npm") Format format, Provider<NpmSecurityFacet> securityFacet, Provider<ConfigurableViewFacet> viewFacet, Provider<NpmContentFacet> contentFacet, Provider<SearchFacet> searchFacet, Provider<BrowseFacet> browseFacet, Provider<NpmRepairComponent> npmRepairComponent, ExceptionHandler exceptionHandler, TimingHandler timingHandler, IndexHtmlForwardHandler indexHtmlForwardHandler, SecurityHandler securityHandler, PartialFetchHandler partialFetchHandler, ConditionalRequestHandler conditionalRequestHandler, ContentHeadersHandler contentHeadersHandler, LastDownloadedHandler lastDownloadedHandler, HandlerContributor handlerContributor, Provider<NpmTokenFacet> tokenFacet, Provider<NpmAuditFacet> npmAuditFacetProvider, Provider<NpmAuditTarballFacet> npmAuditTarballFacetProvider, Provider<NpmProxyComponentMaintenanceFacet> npmProxyComponentMaintenanceFacet, RoutingRuleHandler routingHandler, NpmAuditErrorHandler auditErrorHandler, @Named(value="nexus.analytics.npmAuditHandler") @Nullable Handler auditAnalyticsHandler, Provider<HttpClientFacet> httpClientFacet, Provider<NegativeCacheFacet> negativeCacheFacet, Provider<NpmContentProxyFacet> proxyFacet, Provider<NpmSearchIndexFacetProxy> npmSearchIndexFacetProxy, Provider<NpmSearchFacetProxy> npmSearchFacet, Provider<PurgeUnusedFacet> purgeUnusedFacet, Provider<NpmProxyCacheInvalidatorFacetImpl> npmProxyCacheInvalidatorFacet, NpmNegativeCacheHandler negativeCacheHandler, NpmWhoamiHandler npmWhoamiHandler, NpmAuditQuickHandler auditQuickHandler, NpmAuditBulkHandler auditBulkHandler, NpmAuditHandler auditHandler, NpmPingHandler pingHandler, Provider<NonCatalogedVersionHelperFacet> nonCatalogedVersionHelperFacetProvider, NpmProxyHandler proxyHandler, Provider<NpmQuarantinedVersionFacet> npmQuarantinedVersionFacetProvider) {
        super(type, format, securityFacet, viewFacet, contentFacet, searchFacet, browseFacet, npmRepairComponent, exceptionHandler, timingHandler, indexHtmlForwardHandler, securityHandler, partialFetchHandler, conditionalRequestHandler, contentHeadersHandler, lastDownloadedHandler, handlerContributor, tokenFacet, npmAuditFacetProvider, npmAuditTarballFacetProvider, routingHandler, auditErrorHandler, auditAnalyticsHandler, npmWhoamiHandler, pingHandler);
        this.httpClientFacet = (Provider)Preconditions.checkNotNull(httpClientFacet);
        this.negativeCacheFacet = (Provider)Preconditions.checkNotNull(negativeCacheFacet);
        this.proxyFacet = (Provider)Preconditions.checkNotNull(proxyFacet);
        this.npmSearchIndexFacetProxy = (Provider)Preconditions.checkNotNull(npmSearchIndexFacetProxy);
        this.npmSearchFacet = (Provider)Preconditions.checkNotNull(npmSearchFacet);
        this.purgeUnusedFacet = (Provider)Preconditions.checkNotNull(purgeUnusedFacet);
        this.npmProxyCacheInvalidatorFacet = (Provider)Preconditions.checkNotNull(npmProxyCacheInvalidatorFacet);
        this.npmProxyComponentMaintenanceFacet = (Provider)Preconditions.checkNotNull(npmProxyComponentMaintenanceFacet);
        this.negativeCacheHandler = (NpmNegativeCacheHandler)((Object)Preconditions.checkNotNull((Object)((Object)negativeCacheHandler)));
        this.auditQuickHandler = (NpmAuditQuickHandler)Preconditions.checkNotNull((Object)auditQuickHandler);
        this.auditBulkHandler = (NpmAuditBulkHandler)((Object)Preconditions.checkNotNull((Object)((Object)auditBulkHandler)));
        this.auditHandler = (NpmAuditHandler)Preconditions.checkNotNull((Object)auditHandler);
        this.nonCatalogedVersionHelperFacetProvider = (Provider)Preconditions.checkNotNull(nonCatalogedVersionHelperFacetProvider);
        this.proxyHandler = (NpmProxyHandler)((Object)Preconditions.checkNotNull((Object)((Object)proxyHandler)));
        this.npmQuarantinedVersionFacetProvider = (Provider)Preconditions.checkNotNull(npmQuarantinedVersionFacetProvider);
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.tokenFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.httpClientFacet.get());
        repository.attach((Facet)this.negativeCacheFacet.get());
        repository.attach((Facet)this.contentFacet.get());
        repository.attach((Facet)this.proxyFacet.get());
        repository.attach((Facet)this.searchFacet.get());
        repository.attach((Facet)this.npmRepairComponent.get());
        repository.attach((Facet)this.npmSearchIndexFacetProxy.get());
        repository.attach((Facet)this.npmSearchFacet.get());
        repository.attach((Facet)this.npmProxyComponentMaintenanceFacet.get());
        repository.attach((Facet)this.purgeUnusedFacet.get());
        repository.attach((Facet)this.npmAuditFacetProvider.get());
        repository.attach((Facet)this.npmAuditTarballFacetProvider.get());
        repository.attach((Facet)this.npmProxyCacheInvalidatorFacet.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.nonCatalogedVersionHelperFacetProvider.get());
        repository.attach((Facet)this.npmQuarantinedVersionFacetProvider.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        builder.route(NpmPaths.searchIndexMatcher().handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler(NpmHandlers.npmErrorHandler).handler((Handler)this.negativeCacheHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler(this.proxyTargetHandler(NpmProxyFacet.ProxyTarget.SEARCH_INDEX)).handler((Handler)this.lastDownloadedHandler).handler(NpmHandlers.searchIndex).create());
        builder.route(NpmPaths.searchV1Matcher().handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler(NpmHandlers.npmErrorHandler).handler((Handler)this.negativeCacheHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler(this.proxyTargetHandler(NpmProxyFacet.ProxyTarget.SEARCH_V1_RESULTS)).handler(NpmHandlers.searchV1).create());
        builder.route(NpmPaths.whoamiMatcher().handler((Handler)this.timingHandler).handler((Handler)this.npmWhoamiHandler).create());
        builder.route(NpmPaths.pingMatcher().handler((Handler)this.timingHandler).handler((Handler)this.pingHandler).create());
        builder.route(NpmPaths.auditMatcher().handler(this.auditAnalyticsHandler != null ? this.auditAnalyticsHandler : Context::proceed).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.auditErrorHandler).handler((Handler)this.auditHandler).create());
        builder.route(NpmPaths.auditQuickMatcher().handler(this.auditAnalyticsHandler != null ? this.auditAnalyticsHandler : Context::proceed).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.auditErrorHandler).handler((Handler)this.auditQuickHandler).create());
        builder.route(NpmPaths.auditBulkMatcher().handler(this.auditAnalyticsHandler != null ? this.auditAnalyticsHandler : Context::proceed).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.auditErrorHandler).handler((Handler)this.auditBulkHandler).create());
        builder.route(NpmPaths.packageMatcher("GET", "HEAD").handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((org.sonatype.nexus.repository.recipe.Handler)this.routingHandler).handler(NpmHandlers.npmErrorHandler).handler((Handler)this.negativeCacheHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler(this.proxyTargetHandler(NpmProxyFacet.ProxyTarget.PACKAGE)).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.proxyHandler).create());
        builder.route(NpmPaths.tarballMatcher("GET", "HEAD").handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((org.sonatype.nexus.repository.recipe.Handler)this.routingHandler).handler(NpmHandlers.npmErrorHandler).handler((Handler)this.handlerContributor).handler((Handler)this.negativeCacheHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.contentHeadersHandler).handler(this.proxyTargetHandler(NpmProxyFacet.ProxyTarget.TARBALL)).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.proxyHandler).create());
        builder.route(NpmPaths.distTagsMatcher("GET").handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((org.sonatype.nexus.repository.recipe.Handler)this.routingHandler).handler(NpmHandlers.npmErrorHandler).handler((Handler)this.handlerContributor).handler((Handler)this.contentHeadersHandler).handler(this.proxyTargetHandler(NpmProxyFacet.ProxyTarget.DIST_TAGS)).handler((Handler)this.proxyHandler).create());
        this.createUserRoutes(builder);
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }

    Handler proxyTargetHandler(NpmProxyFacet.ProxyTarget value) {
        return context -> {
            context.getAttributes().set(NpmProxyFacet.ProxyTarget.class, (Object)value);
            return context.proceed();
        };
    }
}

