/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.InternalIds;

@Named
public class NpmHostedMaintenanceFacet
extends NpmFacetSupport
implements ContentMaintenanceFacet {
    @Inject
    public NpmHostedMaintenanceFacet(NpmPackageParser npmPackageParser) {
        super(npmPackageParser);
    }

    public Set<String> deleteComponent(Component component) {
        this.log.debug("Deleting npm component: {}", (Object)component);
        ImmutableSet.Builder deletedAssets = ImmutableSet.builder();
        FluentComponent fluentComponent = ((ContentFacet)this.getRepository().facet(ContentFacet.class)).components().with(component);
        fluentComponent.assets().forEach(asset -> {
            ImmutableSet.Builder builder2 = deletedAssets.addAll(this.deleteAsset((Asset)asset));
        });
        return deletedAssets.build();
    }

    public Set<String> deleteAsset(Asset asset) {
        this.log.debug("Deleting NPM asset: {}", (Object)asset);
        NpmAttributes.AssetKind assetKind = NpmAttributes.AssetKind.valueOf(asset.kind());
        ImmutableSet.Builder deletedAssets = ImmutableSet.builder();
        switch (assetKind) {
            case PACKAGE_ROOT: {
                deletedAssets.addAll(this.deletePackageRoot(asset));
                break;
            }
            case TARBALL: {
                try {
                    deletedAssets.addAll(this.deleteTarball(asset));
                    break;
                }
                catch (IOException e) {
                    this.log.error("Exception deleting tarball for asset: {}", (Object)asset, (Object)e);
                    return Collections.emptySet();
                }
            }
        }
        return deletedAssets.build();
    }

    public int deleteComponents(int[] componentIds) {
        return (int)Arrays.stream(componentIds).boxed().map(InternalIds::toExternalId).map(componentId -> ((ContentFacet)this.getRepository().facet(ContentFacet.class)).components().find(componentId)).filter(Optional::isPresent).map(Optional::get).map(this::deleteComponent).count();
    }

    private Set<String> deletePackageRoot(Asset asset) {
        NpmPackageId packageId = NpmPackageId.parse(this.removeStartingSlash(asset.path()));
        try {
            return ((NpmHostedFacet)this.getRepository().facet(NpmHostedFacet.class)).deletePackage(packageId, null);
        }
        catch (IOException e) {
            this.log.error("Exception delete package root for asset: {}", (Object)asset, (Object)e);
            return Collections.emptySet();
        }
    }

    private Set<String> deleteTarball(Asset asset) throws IOException {
        this.log.debug("Deleting tarball for asset: {}", (Object)asset);
        NpmHostedFacet hostedFacet = (NpmHostedFacet)this.getRepository().facet(NpmHostedFacet.class);
        String assetPath = asset.path();
        String assetNameWithoutStartingSlash = this.removeStartingSlash(assetPath);
        String assetName = assetNameWithoutStartingSlash.substring(0, assetNameWithoutStartingSlash.indexOf("/-/"));
        NpmPackageId packageId = NpmPackageId.parse(assetName);
        String tarballName = NpmMetadataUtils.extractTarballName(assetNameWithoutStartingSlash);
        Optional<FluentAsset> packageRootAsset = this.findPackageRootAsset(packageId);
        if (!packageRootAsset.isPresent()) {
            this.log.debug("No package root present for asset with path: {}", (Object)assetPath);
            return hostedFacet.deleteTarball(packageId, tarballName).map(Collections::singleton).orElseGet(Collections::emptySet);
        }
        NpmContentFacet contentFacet = (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class);
        Optional<NestedAttributesMap> nestedAttributesMapOptional = NpmHostedMaintenanceFacet.loadPackageRoot(packageId, contentFacet);
        if (!nestedAttributesMapOptional.isPresent()) {
            this.log.debug("No attributes for package root present for asset with path: {}", (Object)assetPath);
            return hostedFacet.deletePackage(packageId, null);
        }
        NestedAttributesMap packageRoot = nestedAttributesMapOptional.get();
        NestedAttributesMap versionMap = NpmMetadataUtils.selectVersionByTarballName(packageRoot, tarballName);
        if (versionMap != null) {
            String version = versionMap.getKey();
            packageRoot.child("versions").remove(version);
            this.log.debug("Removing dist tags for asset {} with versionMap {}", (Object)assetPath, (Object)version);
            this.removeDistTagsFromTagsWithVersion(packageRoot, version);
            packageRoot.child("time").remove(version);
        }
        if (packageRoot.child("versions").isEmpty()) {
            return hostedFacet.deletePackage(packageId, null);
        }
        NpmMetadataUtils.maintainTime(packageRoot);
        this.savePackageRoot(packageId, packageRoot);
        return hostedFacet.deleteTarball(packageId, tarballName).map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    private String removeStartingSlash(String toRemoveFrom) {
        return StringUtils.removeStart((String)toRemoveFrom, (String)"/");
    }
}

