/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.content.npm.internal.MissingAssetBlobException;
import com.sonatype.nexus.repository.content.npm.internal.NpmContent;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmGroupUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUpdatedEvent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Named
@Facet.Exposed
public class NpmGroupDataFacet
extends NpmFacetSupport
implements EventAware.Asynchronous {
    private static final Set<String> SKIP_MATCHERS = Sets.newHashSet((Object[])new String[]{"tarball", "_rev"});
    private final boolean mergeMetadata;
    private GroupFacet groupFacet;
    private Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 packageRootCooperation;

    @Inject
    public NpmGroupDataFacet(@Named(value="${nexus.npm.mergeGroupMetadata:-true}") boolean mergeMetadata) {
        super(new NpmPackageParser());
        this.mergeMetadata = mergeMetadata;
    }

    @Inject
    protected void configureCooperation(Cooperation2Factory cooperationFactory, @Named(value="${nexus.npm.packageRoot.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.npm.packageRoot.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.npm.packageRoot.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.npm.packageRoot.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.cooperationBuilder = cooperationFactory.configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    @VisibleForTesting
    void buildCooperation() {
        if (Objects.nonNull(this.cooperationBuilder)) {
            this.packageRootCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":packageRoot");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.groupFacet = (GroupFacet)this.getRepository().facet(GroupFacet.class);
        this.buildCooperation();
    }

    @Nullable
    public Content buildPackageRoot(Map<Repository, Response> responses, Context context) throws IOException {
        if (Objects.isNull(this.packageRootCooperation)) {
            return this.buildMergedPackageRoot(responses, context);
        }
        String cooperationKey = NpmGroupUtils.getCooperationKeyForBuildMergedPackageRoot(context);
        try {
            return (Content)this.packageRootCooperation.on(() -> this.buildMergedPackageRoot(responses, context)).checkFunction(() -> Optional.ofNullable(this.getFromCache(responses, context))).cooperate(cooperationKey, new String[0]);
        }
        catch (IOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{cooperationKey, context.getRepository().getName(), e});
            return null;
        }
    }

    @Nullable
    public NpmContent getFromCache(Map<Repository, Response> responses, Context context) throws IOException {
        Optional<Content> content;
        Optional<FluentAsset> packageRootAsset = this.getPackageRootAssetFromCache(context);
        if (!packageRootAsset.isPresent()) {
            return null;
        }
        FluentAsset asset = null;
        try {
            asset = this.findPackageRootAsset(NpmPaths.packageId(NpmGroupDataFacet.matcherState(context))).orElse(null);
            if (asset != null) {
                asset.download();
            }
        }
        catch (MissingBlobException missingBlobException2) {
            MissingAssetBlobException e = new MissingAssetBlobException((Asset)asset);
            this.buildMergedPackageRootOnMissingBlob(responses, context, e);
        }
        if ((content = this.content().get(NpmPaths.packageId(NpmGroupDataFacet.matcherState(context)))).isPresent()) {
            NpmContent npmContent = NpmGroupDataFacet.toNpmContent(content.get());
            List<NpmFieldMatcher> fieldMatchers = this.getMemberFieldMatchers(responses);
            fieldMatchers.add(NpmFieldFactory.rewriteTarballUrlMatcher(this.getRepository(), packageRootAsset.get().path().substring(1)));
            npmContent.fieldMatchers(fieldMatchers);
            npmContent.packageId(packageRootAsset.get().path().substring(1));
            npmContent.missingBlobInputStreamSupplier((StreamPayload.InputStreamFunction<MissingAssetBlobException>)((StreamPayload.InputStreamFunction)missingBlobException -> this.buildMergedPackageRootOnMissingBlob(responses, context, (MissingAssetBlobException)((Object)missingBlobException))));
            return !this.groupFacet.isStale((Content)npmContent) ? npmContent : null;
        }
        return null;
    }

    protected Optional<FluentAsset> getPackageRootAssetFromCache(Context context) {
        Preconditions.checkNotNull((Object)context);
        return this.findPackageRootAsset(NpmPaths.packageId(NpmGroupDataFacet.matcherState(context)));
    }

    @Nullable
    @VisibleForTesting
    protected Content buildMergedPackageRoot(Map<Repository, Response> responses, Context context) throws IOException {
        NestedAttributesMap result;
        NpmPackageId packageId;
        Preconditions.checkNotNull(responses);
        Preconditions.checkNotNull((Object)context);
        if (responses.isEmpty()) {
            this.log.debug("Unable to create package root for repository {}. Members had no metadata to merge.", (Object)context.getRepository().getName());
            return null;
        }
        List<Content> contents = responses.values().stream().map(response -> (Content)response.getPayload()).collect(Collectors.toList());
        if (this.shouldServeFirstResult(contents, packageId = NpmPaths.packageId(NpmGroupDataFacet.matcherState(context)))) {
            result = NpmMetadataUtils.parseContent((Content)contents.get(0));
        } else {
            this.log.debug("Merging results from {} repositories", (Object)responses.size());
            Collections.reverse(contents);
            result = NpmMetadataUtils.mergeContents(contents);
        }
        NpmMetadataUtils.rewriteTarballUrl(context.getRepository().getName(), result);
        List<NpmFieldMatcher> proxyFieldMatchers = this.getMemberFieldMatchers(responses);
        return this.saveToCache(packageId, result, proxyFieldMatchers);
    }

    private List<NpmFieldMatcher> getMemberFieldMatchers(Map<Repository, Response> responses) {
        return responses.entrySet().stream().flatMap(entry -> {
            NpmContent npmContent = (NpmContent)((Response)entry.getValue()).getPayload();
            if (npmContent != null && npmContent.getFieldMatchers() != null) {
                return npmContent.getFieldMatchers().stream();
            }
            return Stream.empty();
        }).filter(npmFieldMatcher -> !SKIP_MATCHERS.contains(npmFieldMatcher.getFieldName())).collect(Collectors.toList());
    }

    protected Content saveToCache(NpmPackageId packageId, NestedAttributesMap result, List<NpmFieldMatcher> proxyFieldMatchers) throws IOException {
        Asset packageRootAsset = this.savePackageRootToCache(packageId, result);
        ArrayList<NpmFieldMatcher> fieldMatchers = new ArrayList<NpmFieldMatcher>();
        fieldMatchers.addAll(NpmFieldFactory.REMOVE_DEFAULT_FIELDS_MATCHERS);
        fieldMatchers.addAll(proxyFieldMatchers);
        return this.content().get(packageId).map(NpmFacetSupport::toNpmContent).map(npmContent -> npmContent.fieldMatchers(fieldMatchers).packageId(packageRootAsset.path().substring(1))).orElse(null);
    }

    protected Asset savePackageRootToCache(NpmPackageId packageId, NestedAttributesMap result) throws IOException {
        this.savePackageRoot(packageId, result);
        return this.findPackageRootAsset(packageId).orElse(null);
    }

    protected InputStream buildMergedPackageRootOnMissingBlob(Map<Repository, Response> responses, Context context, MissingAssetBlobException e) throws IOException {
        String cooperationKey = NpmGroupUtils.getCooperationKeyForBuildMergedPackageRoot(context);
        Content content = (Content)this.packageRootCooperation.on(() -> this.doBuildMergedPackageRootOnMissingBlob(responses, context, e)).cooperate(cooperationKey, new String[0]);
        return Objects.nonNull(content) ? content.openInputStream() : this.errorInputStream("Unable to retrieve merged package root on recovery for missing blob");
    }

    protected Content doBuildMergedPackageRootOnMissingBlob(Map<Repository, Response> responses, Context context, MissingAssetBlobException e) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.info("Missing blob {} containing cached metadata {}, deleting asset and triggering rebuild.", new Object[]{e.getBlobRef(), e.getAsset(), e});
        } else {
            this.log.info("Missing blob {} containing cached metadata {}, deleting asset and triggering rebuild.", (Object)e.getBlobRef(), (Object)e.getAsset().path());
        }
        return this.buildMergedPackageRoot(responses, context);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent deleted) {
        Repository repository = deleted.getRepository().orElse(null);
        if (repository != null && this.matchingDeletedEvent(deleted, repository)) {
            this.invalidatePackageRoot((AssetEvent)deleted, false);
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetUpdatedEvent updated) {
        Repository repository = updated.getRepository().orElse(null);
        if (this.matchingUpdatedEvent(updated, repository)) {
            this.invalidatePackageRoot((AssetEvent)updated, true);
        }
    }

    private boolean matchingDeletedEvent(AssetDeletedEvent deleted, Repository repository) {
        return this.groupFacet.member(repository) && !InternalIds.internalComponentId((Asset)deleted.getAsset()).isPresent() && !deleted.getAsset().path().contains("/-/v1/search");
    }

    private boolean matchingUpdatedEvent(AssetUpdatedEvent updated, Repository repository) {
        return this.groupFacet.member(repository) && !InternalIds.internalComponentId((Asset)updated.getAsset()).isPresent() && !updated.getAsset().path().contains("/-/v1/search") && this.hasBlobBeenUpdated(updated);
    }

    protected void doInvalidate(NpmPackageId packageId, boolean isDeleted) {
        Optional<FluentAsset> packageRootAsset = this.findPackageRootAsset(packageId);
        packageRootAsset.ifPresent(fluentAsset -> {
            if (!isDeleted) {
                fluentAsset.delete();
            }
            fluentAsset.markAsStale();
        });
    }

    @VisibleForTesting
    protected boolean shouldServeFirstResult(List<?> packages, NpmPackageId packageId) {
        return packages.size() == 1 || !this.mergeMetadata && StringUtils.isEmpty((CharSequence)packageId.scope());
    }

    @Override
    protected Content createPackageRootContent(NestedAttributesMap packageRoot) throws IOException {
        Content content = super.createPackageRootContent(packageRoot);
        this.groupFacet.maintainCacheInfo(content.getAttributes());
        return content;
    }

    private static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    private void invalidatePackageRoot(AssetEvent event, boolean isUpdated) {
        this.doInvalidate(NpmPackageId.parse(event.getAsset().path().substring(1)), isUpdated);
    }

    private boolean hasBlobBeenUpdated(AssetUpdatedEvent updated) {
        OffsetDateTime blobUpdated = updated.getAsset().lastUpdated();
        OffsetDateTime oneMinuteAgo = OffsetDateTime.now().minusMinutes(1L);
        return Objects.isNull(blobUpdated) || blobUpdated.isAfter(oneMinuteAgo);
    }

    public Iterable<Repository> members() {
        return this.groupFacet.members();
    }
}

