/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NonCatalogedVersionHelperFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmContent;
import com.sonatype.nexus.repository.content.npm.internal.NpmContentFacetImpl;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.content.npm.internal.NpmStreamPayload;
import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.internal.NonResolvableTarballNameException;
import com.sonatype.nexus.repository.npm.internal.NpmAuditFacet;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.NpmProxyFacet;
import com.sonatype.nexus.repository.npm.internal.NpmQuarantinedVersionFacet;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.ViewUtils;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.RetryDeniedException;

@Named
public class NpmContentProxyFacet
extends ContentProxyFacetSupport
implements NpmProxyFacet {
    private final NpmPackageParser npmPackageParser;

    @Inject
    public NpmContentProxyFacet(NpmPackageParser npmPackageParser) {
        this.npmPackageParser = npmPackageParser;
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        String bearerToken = ((HttpClientFacet)this.getRepository().facet(HttpClientFacet.class)).getBearerToken();
        if (StringUtils.isNotBlank((CharSequence)bearerToken)) {
            request.setHeader("Authorization", "Bearer " + bearerToken);
        }
        return super.execute(context, client, request);
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        try {
            return super.fetch(context, stale);
        }
        catch (NonResolvableTarballNameException e) {
            this.log.debug("npm tarball URL not resolvable: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        NpmProxyFacet.ProxyTarget npmProxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        if (npmProxyTarget.equals((Object)NpmProxyFacet.ProxyTarget.SEARCH_V1_RESULTS)) {
            return null;
        }
        if (NpmProxyFacet.ProxyTarget.PACKAGE == npmProxyTarget) {
            return this.getPackageRoot(NpmPaths.packageId(this.matcherState(context)), context).orElse(null);
        }
        if (NpmProxyFacet.ProxyTarget.DIST_TAGS == npmProxyTarget) {
            return this.getDistTags(NpmPaths.packageId(this.matcherState(context))).orElse(null);
        }
        if (NpmProxyFacet.ProxyTarget.TARBALL == npmProxyTarget) {
            TokenMatcher.State state = this.matcherState(context);
            return this.getTarball(NpmPaths.packageId(state), NpmPaths.tarballName(state)).orElse(null);
        }
        if (NpmProxyFacet.ProxyTarget.SEARCH_INDEX == npmProxyTarget) {
            return this.getSearchIndex(context);
        }
        throw new IllegalStateException();
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        NpmProxyFacet.ProxyTarget proxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        return this.cacheControllerHolder.require(proxyTarget.getCacheType());
    }

    protected Content store(Context context, Content content) throws IOException {
        NpmProxyFacet.ProxyTarget proxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        if (proxyTarget.equals((Object)NpmProxyFacet.ProxyTarget.SEARCH_V1_RESULTS)) {
            return content;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.contentFacet().blobs().ingest((Payload)content, NpmContentFacetImpl.HASHING);){
            if (NpmProxyFacet.ProxyTarget.PACKAGE == proxyTarget) {
                return this.putPackageRoot(NpmPaths.packageId(this.matcherState(context)), tempBlob, content);
            }
            if (NpmProxyFacet.ProxyTarget.DIST_TAGS == proxyTarget) {
                NpmPackageId packageId = NpmPaths.packageId(this.matcherState(context));
                this.putPackageRoot(packageId, tempBlob, content);
                return this.getDistTags(packageId).orElse(null);
            }
            if (NpmProxyFacet.ProxyTarget.TARBALL == proxyTarget) {
                TokenMatcher.State state = this.matcherState(context);
                return this.putTarball(NpmPaths.packageId(state), NpmPaths.tarballName(state), tempBlob, content, context);
            }
            if (NpmProxyFacet.ProxyTarget.SEARCH_INDEX == proxyTarget) {
                return NpmSearchIndexFilter.filterModifiedSince(this.putRepositoryRoot(tempBlob, content), NpmPaths.indexSince(context.getRequest().getParameters()));
            }
            throw new IllegalStateException();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putRepositoryRoot(TempBlob tempBlob, Content content) {
        return this.contentFacet().putRepositoryRoot((Payload)this.createNpmContent(tempBlob, content));
    }

    private NpmContent createNpmContent(TempBlob tempBlob, Content content) {
        return new NpmContent(new NpmStreamPayload((InputStreamSupplier)tempBlob, content.getContentType()), content);
    }

    private Content putTarball(NpmPackageId packageId, String tarballName, TempBlob tempBlob, Content content, Context context) throws IOException {
        String version;
        try {
            version = this.retrievePackageVersion(packageId, tarballName, context).getKey();
        }
        catch (Exception e) {
            this.log.debug("Unable to get package version from metadata for {}, falling back to the tarball name", (Object)packageId, (Object)e);
            version = NpmCoordinateUtil.extractVersion(tarballName);
        }
        Map<String, Object> formatAttributes = NpmFacetSupport.formatAttributeExtractor(packageId.id(), version, () -> ((TempBlob)tempBlob).get()).apply(this.npmPackageParser, this.log);
        return this.contentFacet().put(packageId, tarballName, version, formatAttributes, (Payload)this.createNpmContent(tempBlob, content));
    }

    protected String getUrl(@Nonnull Context context) {
        String url = context.getRequest().getPath().substring(1);
        NpmProxyFacet.ProxyTarget proxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        if (NpmProxyFacet.ProxyTarget.TARBALL == proxyTarget) {
            url = this.getUrlFromPackageVersion(context);
        } else if (NpmProxyFacet.ProxyTarget.PACKAGE == proxyTarget) {
            NpmPackageId npmPackageId = NpmPaths.packageId(this.matcherState(context));
            url = (String)StringUtils.defaultIfBlank((CharSequence)this.getUrlFromPackageScope(npmPackageId, url), (CharSequence)url);
        } else if (NpmProxyFacet.ProxyTarget.DIST_TAGS == proxyTarget) {
            NpmPackageId npmPackageId = NpmPaths.packageId(this.matcherState(context));
            url = (String)StringUtils.defaultIfBlank((CharSequence)this.getUrlFromPackageScope(npmPackageId, url), (CharSequence)npmPackageId.name());
        } else if (NpmProxyFacet.ProxyTarget.SEARCH_V1_RESULTS == proxyTarget) {
            url = this.buildUrlWithParameters(context, url);
        }
        return url;
    }

    private String buildUrlWithParameters(@Nonnull Context context, String url) {
        Parameters parameters = context.getRequest().getParameters();
        if (parameters != null) {
            url = ViewUtils.buildUrlWithParameters((String)url, (Parameters)parameters);
        }
        return url;
    }

    private String getUrlFromPackageScope(NpmPackageId packageId, String oldUrl) {
        if (packageId.scope() != null) {
            String newUrl = "@" + packageId.scope() + "%2f" + packageId.name();
            this.log.trace("Scoped package URL fix: {} -> {}", (Object)oldUrl, (Object)newUrl);
            return newUrl;
        }
        return null;
    }

    private String getUrlFromPackageVersion(@Nonnull Context context) {
        TokenMatcher.State state = this.matcherState(context);
        try {
            NestedAttributesMap packageVersion = this.retrievePackageVersion(NpmPaths.packageId(state), NpmPaths.tarballName(state), context);
            return (String)packageVersion.child("dist").get("tarball", String.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private NestedAttributesMap retrievePackageVersion(NpmPackageId packageId, String tarballName, Context context) throws IOException {
        NpmMetadataUtils.retrievePackageRoot(packageId, context, this.getRepository());
        Optional<FluentAsset> packageRootAsset = this.findPackageRootAsset(packageId);
        if (!packageRootAsset.isPresent()) {
            throw new NonResolvableTarballNameException("Could not find package " + packageId);
        }
        NestedAttributesMap packageVersion = NpmMetadataUtils.selectVersionByTarballName(this.loadPackageRoot(packageRootAsset.get()), tarballName);
        if (packageVersion == null) {
            throw new NonResolvableTarballNameException("Could not find package " + packageId + " version for " + tarballName);
        }
        return packageVersion;
    }

    private TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    private Optional<Content> getPackageRoot(NpmPackageId packageId, Context context) {
        Optional<FluentAsset> asset = this.findPackageRootAsset(packageId);
        try {
            return asset.map(theAsset -> this.packageRootNpmContent(packageId, (FluentAsset)theAsset));
        }
        catch (MissingBlobException exception) {
            this.doGetOnMissingBlob(context, exception, asset.get());
            return this.findPackageRootAsset(packageId).map(theAsset -> this.packageRootNpmContent(packageId, (FluentAsset)theAsset));
        }
    }

    private NpmContent packageRootNpmContent(NpmPackageId packageId, FluentAsset asset) {
        return this.assetToNpmContent(asset, packageId).fieldMatchers(this.getFieldMatchers(packageId, asset, this.getRepository())).packageId(asset.path().substring(1));
    }

    private NpmContent assetToNpmContent(FluentAsset packageRootAsset, NpmPackageId packageId) {
        return NpmFacetSupport.toNpmContent(packageRootAsset.download()).fieldMatchers(NpmFieldFactory.rewriteTarballUrlMatcher(this.getRepository(), packageId.id()));
    }

    private Optional<FluentAsset> findPackageRootAsset(NpmPackageId npmPackageId) {
        return this.getAsset(NpmContentFacet.metadataPath(npmPackageId));
    }

    private Optional<FluentAsset> getAsset(String path) {
        return this.contentFacet().assets().path(path).find();
    }

    private NpmContentFacet contentFacet() {
        return (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class);
    }

    private Optional<Content> doGetOnMissingBlob(Context context, MissingBlobException e, FluentAsset asset) {
        this.log.warn("Unable to find blob {} for {}, will check remote", (Object)e.getBlobRef(), (Object)this.getUrl(context));
        try {
            return Optional.ofNullable(this.get(context, null));
        }
        catch (IOException ex) {
            this.log.error(String.format("Missing blob for %s. Unable to check remote %s for retrieving latest copy.", asset.path(), this.getUrl(context)), (Throwable)ex);
            return Optional.empty();
        }
    }

    private Optional<Content> getDistTags(NpmPackageId packageId) throws IOException {
        return NpmFacetSupport.loadPackageRoot(packageId, this.contentFacet()).map(packageRootJson -> packageRootJson.child("dist-tags")).map(distTags -> this.distTagsToContent((NestedAttributesMap)distTags, packageId));
    }

    private Content distTagsToContent(NestedAttributesMap distTags, NpmPackageId packageId) {
        try {
            return NpmFacetSupport.distTagsToContent(distTags);
        }
        catch (IOException e) {
            this.log.error("Unable to read packageRoot {}", (Object)packageId.id(), (Object)e);
            return null;
        }
    }

    private Optional<Content> getTarball(NpmPackageId packageId, String tarballName) {
        return this.getAsset(NpmFacetSupport.tarballAssetName(packageId, tarballName)).map(FluentAsset::download);
    }

    private Content getSearchIndex(Context context) throws IOException {
        Optional<Content> content = this.getAsset("/-/all").map(FluentAsset::download);
        if (content.isPresent()) {
            return NpmSearchIndexFilter.filterModifiedSince(content.get(), NpmPaths.indexSince(context.getRequest().getParameters()));
        }
        return null;
    }

    private Content putPackageRoot(NpmPackageId packageId, TempBlob tempBlob, Content content) throws IOException {
        NestedAttributesMap packageRoot = NpmJsonUtils.parse((InputStreamSupplier)tempBlob);
        try {
            return this.doPutPackageRoot(packageId, packageRoot, true, content);
        }
        catch (MissingBlobException | RetryDeniedException ex) {
            return this.maybeHandleMissingBlob((RuntimeException)ex, packageId, packageRoot, content);
        }
    }

    private Content doPutPackageRoot(NpmPackageId packageId, NestedAttributesMap packageRoot, boolean mergePackageRoot, Content content) throws IOException {
        this.log.debug("Storing package: {}", (Object)packageId);
        NestedAttributesMap newPackageRoot = packageRoot;
        Optional<FluentAsset> maybePackageRootAsset = this.findPackageRootAsset(packageId);
        if (maybePackageRootAsset.isPresent() && mergePackageRoot) {
            newPackageRoot = this.mergeNewRootWithExistingRoot(newPackageRoot, maybePackageRootAsset.get());
        }
        FluentAsset asset = this.savePackageRoot(packageId, newPackageRoot, content);
        return this.assetToNpmContent(asset, packageId).fieldMatchers(this.getFieldMatchers(packageId, asset, this.getRepository())).revId(asset.path()).packageId(packageId.id());
    }

    private FluentAsset savePackageRoot(NpmPackageId packageId, NestedAttributesMap packageRoot, Content content) throws IOException {
        packageRoot.remove("_id");
        packageRoot.remove("_attachments");
        NpmMetadataUtils.maintainTime(packageRoot);
        NpmStreamPayload payload = new NpmStreamPayload(() -> new ByteArrayInputStream(NpmJsonUtils.bytes(packageRoot)), content.getContentType());
        return this.contentFacet().put(packageId, (Payload)new NpmContent(payload, content));
    }

    private NestedAttributesMap mergeNewRootWithExistingRoot(NestedAttributesMap newPackageRoot, FluentAsset asset) throws IOException {
        NestedAttributesMap existingPackageRoot = this.loadPackageRoot(asset);
        return NpmMetadataUtils.mergePackageRoots(newPackageRoot, existingPackageRoot, NpmMetadataUtils.findCachedVersionsRemovedFromRemote(existingPackageRoot, newPackageRoot, this.componentExists()));
    }

    private BiFunction<NpmPackageId, String, Boolean> componentExists() {
        return (packageId, version) -> {
            FluentComponentBuilder componentBuilder = this.contentFacet().components().name(packageId.name()).version(version);
            if (packageId.scope() != null) {
                componentBuilder = componentBuilder.namespace(packageId.scope());
            }
            return componentBuilder.find().isPresent();
        };
    }

    private NestedAttributesMap loadPackageRoot(FluentAsset asset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Content content = asset.download();){
            NestedAttributesMap metadata = NpmJsonUtils.parse(() -> ((Content)content).openInputStream());
            metadata.set("_id", (Object)asset.path());
            return metadata;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content maybeHandleMissingBlob(RuntimeException e, NpmPackageId packageId, NestedAttributesMap packageRoot, Content content) throws IOException {
        BlobRef blobRef = null;
        if (e instanceof MissingBlobException) {
            blobRef = ((MissingBlobException)((Object)e)).getBlobRef();
        } else if (e.getCause() instanceof MissingBlobException) {
            blobRef = ((MissingBlobException)e.getCause()).getBlobRef();
        }
        if (Objects.nonNull(blobRef)) {
            this.log.warn("Unable to find blob {} for {}, skipping merge of package root", (Object)blobRef, (Object)packageId);
            return this.doPutPackageRoot(packageId, packageRoot, false, content);
        }
        throw e;
    }

    @Override
    public void invalidateProxyCaches() {
        super.invalidateProxyCaches();
        NpmAuditFacet npmAuditFacet = (NpmAuditFacet)this.getRepository().facet(NpmAuditFacet.class);
        npmAuditFacet.clearCache();
        ((NonCatalogedVersionHelperFacet)this.facet(NonCatalogedVersionHelperFacet.class)).clearCache();
        ((NpmQuarantinedVersionFacet)this.facet(NpmQuarantinedVersionFacet.class)).clearCache();
    }

    private List<NpmFieldMatcher> getFieldMatchers(NpmPackageId packageId, FluentAsset packageRootAsset, Repository repository) {
        ArrayList<NpmFieldMatcher> fieldMatchers = new ArrayList<NpmFieldMatcher>();
        ((NonCatalogedVersionHelperFacet)repository.facet(NonCatalogedVersionHelperFacet.class)).maybeAddExcludedVersionsFieldMatchers(fieldMatchers, packageRootAsset, repository);
        if (packageRootAsset.hasBlob()) {
            BlobRef blobRef = packageRootAsset.blob().map(AssetBlob::blobRef).orElse(null);
            ((NpmQuarantinedVersionFacet)repository.facet(NpmQuarantinedVersionFacet.class)).maybeAddExcludedVersionsFieldMatchers(fieldMatchers, packageId, blobRef, repository);
        }
        fieldMatchers.add(NpmFieldFactory.rewriteTarballUrlMatcher(this.getRepository(), packageId.id()));
        return fieldMatchers;
    }
}

