/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="npm")
public class NpmContentFacetImpl
extends ContentFacetSupport
implements NpmContentFacet {
    public static final List<HashAlgorithm> HASHING = ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.MD5);
    private static final String REPOSITORY_ROOT_ASSET = "/-/all";
    private static final String REPOSITORY_SEARCH_ASSET = "/-/v1/search";
    @Inject
    private MimeSupport mimeSupport;

    @Inject
    public NpmContentFacetImpl(@Named(value="npm") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    public Optional<Content> get(NpmPackageId packageId) throws IOException {
        return this.findAsset(NpmContentFacet.metadataPath(packageId)).map(FluentAsset::download);
    }

    @Override
    public FluentAsset put(NpmPackageId packageId, Payload content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.blobs().ingest(content, HASHING);){
            String path = NpmContentFacet.metadataPath(packageId);
            this.save(content, null, NpmAttributes.AssetKind.PACKAGE_ROOT, null, blob, path);
            return this.findAsset(path).get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean delete(NpmPackageId packageId) throws IOException {
        return this.maybeDeleteAsset(NpmContentFacet.metadataPath(packageId));
    }

    @Override
    public Optional<Content> get(NpmPackageId packageId, String version) throws IOException {
        return this.findAsset(NpmContentFacet.tarballPath(packageId, version)).map(FluentAsset::download);
    }

    @Override
    public FluentAsset put(NpmPackageId packageId, TempBlob tempBlob) throws IOException {
        String path = NpmContentFacet.metadataPath(packageId);
        this.save(null, null, NpmAttributes.AssetKind.PACKAGE_ROOT, null, tempBlob, path);
        return this.findAsset(path).get();
    }

    @Override
    public Content put(NpmPackageId packageId, String version, Map<String, Object> npmAttributes, Payload content) {
        return this.putTarball(packageId, version, npmAttributes, content, NpmContentFacet.tarballPath(packageId, version));
    }

    @Override
    public Content put(NpmPackageId packageId, String tarballName, String version, Map<String, Object> npmAttributes, Payload content) {
        return this.putTarball(packageId, version, npmAttributes, content, NpmContentFacet.tarballPath(packageId.id(), tarballName));
    }

    private Content putTarball(NpmPackageId packageId, String version, Map<String, Object> npmAttributes, Payload content, String path) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob blob = this.blobs().ingest(content, HASHING);){
            FluentComponent component = this.getOrCreateComponent(packageId, version);
            return this.save(content, component, NpmAttributes.AssetKind.TARBALL, npmAttributes, blob, path);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content put(NpmPackageId packageId, String version, Map<String, Object> npmAttributes, TempBlob blob) throws IOException {
        FluentComponent component = this.getOrCreateComponent(packageId, version);
        String path = NpmContentFacet.tarballPath(packageId, version);
        return this.save(null, component, NpmAttributes.AssetKind.TARBALL, npmAttributes, blob, path);
    }

    @Override
    public FluentAsset saveTarball(NpmPackageId packageId, String version, Map<String, Object> npmAttributes, Blob blob) {
        FluentComponent component = this.getOrCreateComponent(packageId, version);
        String path = NpmContentFacet.tarballPath(packageId, version);
        HashCode hashCode = HashCode.fromString((String)blob.getMetrics().getSha1Hash());
        return this.assets().path(path).kind(NpmAttributes.AssetKind.TARBALL.name()).component((Component)component).attributes("npm", npmAttributes).blob(blob, Collections.singletonMap(HashAlgorithm.SHA1, hashCode)).save();
    }

    @Override
    public Content putSearchIndex(Payload content) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.blobs().ingest(content, HASHING);){
            return this.save(content, null, NpmAttributes.AssetKind.REPOSITORY_ROOT, null, blob, REPOSITORY_SEARCH_ASSET);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putRepositoryRoot(Payload content) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.blobs().ingest(content, HASHING);){
            return this.save(content, null, NpmAttributes.AssetKind.REPOSITORY_ROOT, null, blob, REPOSITORY_ROOT_ASSET);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean delete(NpmPackageId packageId, String version) throws IOException {
        boolean assetDeleted = this.maybeDeleteAsset(NpmContentFacet.tarballPath(packageId, version));
        if (assetDeleted) {
            this.maybeDeleteComponent(packageId, version);
        }
        return assetDeleted;
    }

    @Override
    public Blob getHardLinkingBlob(File content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        String path = content.getPath();
        Path contentPath = content.toPath();
        ImmutableMap headers = ImmutableMap.of((Object)"BlobStore.blob-name", (Object)path, (Object)"BlobStore.content-type", (Object)this.mimeSupport.detectMimeType(Files.newInputStream(contentPath, new OpenOption[0]), path));
        HashCode hashCode = Hashing.sha1().hashBytes(Files.readAllBytes(contentPath));
        return this.blobs().ingest(contentPath, (Map)headers, hashCode, Files.size(contentPath));
    }

    private FluentComponent getOrCreateComponent(NpmPackageId packageId, String version) {
        FluentComponentBuilder builder = this.components().name(packageId.name()).version(version);
        if (packageId.scope() != null) {
            builder.namespace(packageId.scope());
        }
        return builder.getOrCreate();
    }

    private void maybeDeleteComponent(NpmPackageId packageId, String version) {
        FluentComponentBuilder component = this.components().name(packageId.name()).version(version);
        if (packageId.scope() != null) {
            component.namespace(packageId.scope());
        }
        component.find().ifPresent(NpmContentFacetImpl::deleteIfNoAssetsLeft);
    }

    private Content save(@Nullable Payload content, @Nullable FluentComponent component, NpmAttributes.AssetKind assetKind, @Nullable Map<String, Object> npmAttributes, TempBlob blob, String path) {
        FluentAssetBuilder assetBuilder = this.assets().path(path).kind(assetKind.name());
        if (component != null) {
            assetBuilder = assetBuilder.component((Component)component);
        }
        FluentAsset asset = assetBuilder.blob(blob).save().markAsCached(content);
        if (npmAttributes != null && !npmAttributes.isEmpty()) {
            asset.withAttribute("npm", npmAttributes);
        }
        return asset.download();
    }

    private boolean maybeDeleteAsset(String path) {
        return this.findAsset(path).map(FluentAsset::delete).orElse(false);
    }

    private Optional<FluentAsset> findAsset(String path) {
        return this.assets().path(path).find();
    }

    private static void deleteIfNoAssetsLeft(FluentComponent component) {
        if (component.assets().isEmpty()) {
            component.delete();
        }
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy configuredWritePolicy = super.writePolicy(asset);
        if (WritePolicy.ALLOW_ONCE == configuredWritePolicy) {
            String assetKind = asset.kind();
            if (StringUtils.equals((CharSequence)NpmAttributes.AssetKind.PACKAGE_ROOT.name(), (CharSequence)assetKind) || StringUtils.equals((CharSequence)NpmAttributes.AssetKind.REPOSITORY_ROOT.name(), (CharSequence)assetKind)) {
                return WritePolicy.ALLOW;
            }
        }
        return configuredWritePolicy;
    }
}

