/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmPackageRootMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.view.Content;

@Named(value="npm")
@Singleton
public class NpmContentDirector
extends ComponentSupport
implements ContentDirector {
    private final NpmPackageParser npmPackageParser;

    @Inject
    public NpmContentDirector(NpmPackageParser npmPackageParser) {
        this.npmPackageParser = npmPackageParser;
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(FluentComponent component, Repository destination) {
        return true;
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public void afterMove(List<Map<String, String>> components, Repository destination) {
        destination.optionalFacet(NpmHostedFacet.class).ifPresent(npmHostedFacet -> {
            NpmContentFacet contentFacet = (NpmContentFacet)destination.facet(NpmContentFacet.class);
            components.forEach(componentMap -> contentFacet.components().name((String)componentMap.get("name")).namespace((String)componentMap.get("group")).version((String)componentMap.get("version")).find().ifPresent(component -> component.assets().forEach(asset -> this.updatePackageRoot((FluentAsset)asset, destination, contentFacet, (NpmHostedFacet)npmHostedFacet))));
        });
    }

    private void updatePackageRoot(FluentAsset asset, Repository destination, NpmContentFacet contentFacet, NpmHostedFacet npmHostedFacet) {
        BlobRef blobRef = ((AssetBlob)asset.blob().orElseThrow(NullPointerException::new)).blobRef();
        Blob blob = (Blob)contentFacet.blobs().blob(blobRef).orElseThrow(NullPointerException::new);
        Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson(() -> ((Blob)blob).getInputStream());
        NpmPackageId packageId = NpmPackageId.parse((String)packageJson.get("name"));
        NestedAttributesMap packageJsonAttributesMap = new NestedAttributesMap("metadata", packageJson);
        try {
            NestedAttributesMap updatedMetadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(packageJsonAttributesMap, destination.getName(), blob.getMetrics().getSha1Hash(), NpmContentDirector.getPackageRootLatestVersion(packageJsonAttributesMap, contentFacet), NpmVersionComparator.extractNewestVersion);
            npmHostedFacet.putPackageRoot(packageId, null, updatedMetadata);
        }
        catch (IOException e) {
            this.log.error("Failed to update package root, packageId: {}", (Object)packageId, (Object)e);
        }
    }

    private static String getPackageRootLatestVersion(NestedAttributesMap packageJson, NpmContentFacet contentFacet) throws IOException {
        NestedAttributesMap packageRoot;
        String latestVersion;
        NpmPackageId packageId = NpmPackageId.parse((String)packageJson.get("name"));
        Optional<Content> maybePackageRootContent = contentFacet.get(packageId);
        if (maybePackageRootContent.isPresent() && Objects.nonNull(latestVersion = NpmMetadataUtils.getLatestVersionFromPackageRoot(packageRoot = NpmJsonUtils.parse(() -> ((Content)maybePackageRootContent.get()).openInputStream())))) {
            return latestVersion;
        }
        return "";
    }
}

