/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.AssetPathBrowseNodeGenerator;

@Singleton
@Named(value="npm")
public class NpmBrowseNodeGenerator
extends AssetPathBrowseNodeGenerator {
    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        List nameParts = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)asset.path());
        String assetName = (String)nameParts.get(nameParts.size() - 1);
        return super.computeAssetPaths(asset).stream().filter(paths -> !"-".equals(paths.getDisplayName())).map(path -> NpmBrowseNodeGenerator.renameIfHashed(path, assetName, asset)).collect(Collectors.toList());
    }

    private static BrowsePath renameIfHashed(BrowsePath path, String assetName, Asset asset) {
        if (NpmBrowseNodeGenerator.isHash(path.getDisplayName()) && path.getDisplayName().equals(assetName) && asset.component().isPresent()) {
            return new BrowsePath(NpmBrowseNodeGenerator.buildDisplayName((Component)asset.component().get(), asset).orElse(path.getDisplayName()), path.getRequestPath());
        }
        return path;
    }

    private static Optional<String> buildDisplayName(Component component, Asset asset) {
        return Optional.ofNullable((String)asset.attributes("npm").get("name", String.class)).map(npmName -> StringUtils.removeStart((String)npmName, (String)"@").replaceAll("[@/]+", "-")).map(formattedName -> String.format("%s-%s.tgz", formattedName, component.version()));
    }

    private static boolean isHash(String tarballName) {
        return !tarballName.endsWith(".tgz") && !tarballName.endsWith(".tar.gz");
    }
}

