/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.content.npm.INpmHostedFacet;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.NpmUploadHandler;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;

@Singleton
@Named(value="npm")
public class NpmUploadHandlerImpl
extends UploadHandlerSupport
implements NpmUploadHandler {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;
    private final NpmPackageParser npmPackageParser;
    protected static final List<HashAlgorithm> HASH_ALGORITHMS = Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1});

    @Inject
    public NpmUploadHandlerImpl(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, NpmPackageParser npmPackageParser, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = (VariableResolverAdapter)Preconditions.checkNotNull((Object)variableResolverAdapter);
        this.npmPackageParser = (NpmPackageParser)((Object)Preconditions.checkNotNull((Object)((Object)npmPackageParser)));
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        NpmContentFacet contentFacet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        INpmHostedFacet hostedFacet = (INpmHostedFacet)repository.facet(INpmHostedFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        if (!payload.getName().endsWith(".tgz")) {
            throw new IllegalArgumentException("Unsupported extension. Extension must be .tgz");
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = contentFacet.blobs().ingest((Payload)payload, HASH_ALGORITHMS);){
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson((InputStreamSupplier)tempBlob);
            this.ensureNpmPermitted(repository, packageJson);
            Content content = hostedFacet.putPackage(packageJson, (Payload)new TempBlobPayload(tempBlob));
            NpmPackageId packageId = NpmPackageId.parse((String)Preconditions.checkNotNull((Object)packageJson.get("name")));
            String version = (String)packageJson.get("version");
            return new UploadResponse(content, Collections.singletonList(NpmContentFacet.tarballPath(packageId, version)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        this.ensurePermitted(configuration.getRepository().getName(), "npm", configuration.getAssetName(), Collections.emptyMap());
        return this.doPut(configuration);
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("npm", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public boolean supportsExportImport() {
        return true;
    }

    @Override
    public Content doPut(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        File content = configuration.getFile();
        Path contentPath = content.toPath();
        NpmContentFacet contentFacet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        INpmHostedFacet hostedFacet = (INpmHostedFacet)repository.facet(INpmHostedFacet.class);
        if (configuration.isHardLinkingEnabled()) {
            Blob blob = contentFacet.getHardLinkingBlob(content);
            HashCode hashCode = HashCode.fromString((String)blob.getMetrics().getSha1Hash());
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson(() -> Objects.requireNonNull(blob.getInputStream()));
            this.ensureNpmPermitted(repository, packageJson);
            return hostedFacet.putPackageBlob(packageJson, blob, hashCode).download();
        }
        Throwable throwable = null;
        Object var8_11 = null;
        try (TempBlob tempBlob = contentFacet.blobs().ingest((InputStream)new BufferedInputStream(Files.newInputStream(content.toPath(), new OpenOption[0])), Files.probeContentType(contentPath), HASH_ALGORITHMS);){
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson((InputStreamSupplier)tempBlob);
            this.ensureNpmPermitted(repository, packageJson);
            return hostedFacet.putPackage(packageJson, (Payload)new TempBlobPayload(tempBlob));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

