/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.internal.DirectoryHelper;
import org.sonatype.nexus.bootstrap.osgi.FilterTracker;
import org.sonatype.nexus.bootstrap.osgi.ListenerTracker;

public class BootstrapListener
implements ServletContextListener {
    private static final String NEXUS_LOAD_AS_OSS_PROP_NAME = "nexus.loadAsOSS";
    private static final String EDITION_PRO = "edition_pro";
    private static final Logger log = LoggerFactory.getLogger(BootstrapListener.class);
    private static final String NEXUS_EDITION = "nexus-edition";
    private static final String NEXUS_FULL_EDITION = "nexus-full-edition";
    private static final String NEXUS_FEATURES = "nexus-features";
    private static final String NEXUS_PRO_FEATURE = "nexus-pro-feature";
    private static final String NEXUS_OSS_EDITION = "nexus-oss-edition";
    private static final String NEXUS_OSS_FEATURE = "nexus-oss-feature";
    private static final String NEXUS_DB_FEATURE = "nexus-db-feature";
    private static final String NEXUS_EXCLUDE_FEATURES = "nexus-exclude-features";
    private ListenerTracker listenerTracker;
    private FilterTracker filterTracker;

    public void contextInitialized(ServletContextEvent event) {
        log.info("Initializing");
        ServletContext servletContext = event.getServletContext();
        try {
            Properties properties = System.getProperties();
            if (properties == null) {
                throw new IllegalStateException("Missing bootstrap configuration properties");
            }
            BootstrapListener.requireProperty(properties, "karaf.base");
            BootstrapListener.requireProperty(properties, "karaf.data");
            File workDir = new File(properties.getProperty("karaf.data")).getCanonicalFile();
            Path workDirPath = workDir.toPath();
            DirectoryHelper.mkdir(workDirPath);
            if (this.hasProFeature(properties)) {
                if (this.shouldSwitchToOss(workDirPath)) {
                    this.adjustEditionProperties(properties);
                } else {
                    this.createProEditionMarker(workDirPath);
                }
            }
            BootstrapListener.selectDatastoreFeature(properties);
            BootstrapListener.selectAuthenticationFeature(properties);
            servletContext.setAttribute("nexus.properties", (Object)properties);
            Bundle containingBundle = FrameworkUtil.getBundle(this.getClass());
            if (containingBundle == null) {
                throw new UnsupportedOperationException("Missing OSGi container");
            }
            BundleContext bundleContext = containingBundle.getBundleContext();
            BootstrapListener.requireProperty(properties, NEXUS_EDITION);
            BootstrapListener.requireProperty(properties, NEXUS_DB_FEATURE);
            BootstrapListener.installNexusEdition(bundleContext, properties);
            this.listenerTracker = new ListenerTracker(bundleContext, "nexus", servletContext);
            this.listenerTracker.open();
            this.filterTracker = new FilterTracker(bundleContext, "nexus");
            this.filterTracker.open();
            this.listenerTracker.waitForService(0L);
            this.filterTracker.waitForService(0L);
        }
        catch (Exception e) {
            log.error("Failed to initialize", (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        log.info("Initialized");
    }

    private boolean hasProFeature(Properties properties) {
        return properties.getProperty(NEXUS_FEATURES, "").contains(NEXUS_PRO_FEATURE);
    }

    private void adjustEditionProperties(Properties properties) {
        log.info("Loading OSS Edition");
        properties.put(NEXUS_EDITION, NEXUS_OSS_EDITION);
        properties.put(NEXUS_FEATURES, properties.getProperty(NEXUS_FEATURES).replace(NEXUS_PRO_FEATURE, NEXUS_OSS_FEATURE));
    }

    boolean shouldSwitchToOss(Path workDirPath) {
        File proEditionMarker = this.getProEditionMarker(workDirPath);
        boolean switchToOss = this.hasNexusLoadAsOSS() ? this.isNexusLoadAsOSS() : (proEditionMarker.exists() ? false : (this.isNexusClustered() ? false : this.isNullNexusLicenseFile() && this.isNullJavaPrefLicense()));
        return switchToOss;
    }

    boolean hasNexusLoadAsOSS() {
        return System.getProperty(NEXUS_LOAD_AS_OSS_PROP_NAME) != null;
    }

    boolean isNexusLoadAsOSS() {
        return Boolean.getBoolean(NEXUS_LOAD_AS_OSS_PROP_NAME);
    }

    File getProEditionMarker(Path workDirPath) {
        return workDirPath.resolve(EDITION_PRO).toFile();
    }

    private void createProEditionMarker(Path workDirPath) {
        File proEditionMarker = this.getProEditionMarker(workDirPath);
        try {
            if (proEditionMarker.createNewFile()) {
                log.debug("Created pro edition marker file: {}", (Object)proEditionMarker);
            }
        }
        catch (IOException e) {
            log.error("Failed to create pro edition marker file: {}", (Object)proEditionMarker, (Object)e);
        }
    }

    boolean isNexusClustered() {
        return Boolean.getBoolean("nexus.clustered");
    }

    boolean isNullNexusLicenseFile() {
        return System.getProperty("nexus.licenseFile") == null;
    }

    boolean isNullJavaPrefLicense() {
        Thread currentThread = Thread.currentThread();
        ClassLoader tccl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            boolean bl = Preferences.userRoot().node("/com/sonatype/nexus/professional").get("license", null) == null;
            return bl;
        }
        finally {
            currentThread.setContextClassLoader(tccl);
        }
    }

    private static void selectDatastoreFeature(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.developer", "false"))) {
            properties.setProperty("nexus.datastore.enabled", "true");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.clustered.enabled", "false"))) {
            properties.setProperty("nexus.datastore.enabled", "true");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.search.enabled", "false"))) {
            properties.setProperty("nexus.datastore.enabled", "true");
            properties.setProperty("nexus.elasticsearch.enabled", "false");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.elasticsearch.enabled", "false"))) {
            properties.setProperty("nexus.datastore.search.enabled", "false");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.enabled", "false"))) {
            properties.setProperty("nexus.orient.enabled", "false");
            if (!Boolean.parseBoolean(properties.getProperty("nexus.datastore.developer", "false"))) {
                properties.setProperty(NEXUS_EXCLUDE_FEATURES, properties.getProperty(NEXUS_EXCLUDE_FEATURES, ""));
            }
        }
        BootstrapListener.selectDbFeature(properties);
    }

    private static void selectDbFeature(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("nexus.orient.enabled", "true"))) {
            properties.setProperty(NEXUS_DB_FEATURE, "nexus-orient");
            properties.setProperty("nexus.orient.enabled", "true");
        } else {
            properties.setProperty(NEXUS_DB_FEATURE, "nexus-datastore-mybatis");
            properties.setProperty("nexus.datastore.enabled", "true");
            properties.setProperty("nexus.quartz.jobstore.jdbc", "true");
            if (NEXUS_OSS_EDITION.equals(properties.getProperty(NEXUS_EDITION))) {
                properties.setProperty(NEXUS_EXCLUDE_FEATURES, "nexus-cma-feature," + properties.getProperty(NEXUS_EXCLUDE_FEATURES, ""));
            }
        }
    }

    private static void selectAuthenticationFeature(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("nexus.session.enabled", "true"))) {
            properties.setProperty("nexus.session.enabled", "true");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.jwt.enabled", "false"))) {
            properties.setProperty("nexus.session.enabled", "false");
        }
    }

    private static void installNexusEdition(BundleContext ctx, Properties properties) throws Exception {
        String editionName = properties.getProperty(NEXUS_EDITION);
        if (editionName != null && editionName.length() > 0) {
            tracker.open();
            try (ServiceTracker tracker = new ServiceTracker(ctx, FeaturesService.class, null);){
                FeaturesService featuresService = (FeaturesService)tracker.waitForService(1000L);
                Feature editionFeature = featuresService.getFeature(editionName);
                properties.put(NEXUS_FULL_EDITION, editionFeature.toString());
                Feature dbFeature = featuresService.getFeature(properties.getProperty(NEXUS_DB_FEATURE));
                log.info("Installing: {} ({})", (Object)editionFeature, (Object)dbFeature);
                LinkedHashSet<String> featureIds = new LinkedHashSet<String>();
                if (!featuresService.isInstalled(editionFeature)) {
                    featureIds.add(editionFeature.getId());
                }
                if (!featuresService.isInstalled(dbFeature)) {
                    featureIds.add(dbFeature.getId());
                }
                if (!featureIds.isEmpty()) {
                    EnumSet<FeaturesService.Option> options = EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles, FeaturesService.Option.NoAutoRefreshManagedBundles);
                    featuresService.installFeatures(featureIds, options);
                }
                log.info("Installed: {} ({})", (Object)editionFeature, (Object)dbFeature);
            }
        }
    }

    private static void requireProperty(Properties properties, String name) {
        if (!properties.containsKey(name)) {
            throw new IllegalStateException("Missing required property: " + name);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        log.info("Destroying");
        if (this.filterTracker != null) {
            this.filterTracker.close();
            this.filterTracker = null;
        }
        if (this.listenerTracker != null) {
            this.listenerTracker.close();
            this.listenerTracker = null;
        }
        log.info("Destroyed");
    }
}

