/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotItem;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.internal.snapshot.OrientAptSnapshotFacetSupport;
import org.sonatype.nexus.repository.view.Content;

@Named
public class OrientAptHostedSnapshotFacet
extends OrientAptSnapshotFacetSupport {
    @Override
    protected List<SnapshotItem> fetchSnapshotItems(List<SnapshotItem.ContentSpecifier> specs) throws IOException {
        ArrayList<SnapshotItem> list = new ArrayList<SnapshotItem>();
        for (SnapshotItem.ContentSpecifier spec : specs) {
            SnapshotItem item = this.getItem(spec);
            if (item == null) continue;
            list.add(item);
        }
        return list;
    }

    private SnapshotItem getItem(SnapshotItem.ContentSpecifier spec) throws IOException {
        OrientAptFacet apt = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        Optional<Content> content = apt.get(spec.path);
        return content.map(value -> new SnapshotItem(spec, (Content)value)).orElse(null);
    }
}

