/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class OrientAptHostedHandler
extends ComponentSupport
implements Handler {
    public Response handle(Context context) throws Exception {
        String path = this.assetPath(context);
        String method = context.getRequest().getAction();
        OrientAptFacet aptFacet = (OrientAptFacet)context.getRepository().facet(OrientAptFacet.class);
        OrientAptHostedFacet hostedFacet = (OrientAptHostedFacet)context.getRepository().facet(OrientAptHostedFacet.class);
        switch (method) {
            case "GET": 
            case "HEAD": {
                return this.doGet(path, aptFacet);
            }
            case "POST": {
                return this.doPost(context, path, method, hostedFacet);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "POST"});
    }

    private Response doPost(Context context, String path, String method, OrientAptHostedFacet hostedFacet) throws IOException {
        if ("rebuild-indexes".equals(path)) {
            hostedFacet.rebuildIndexes();
            return HttpResponses.ok();
        }
        if ("".equals(path)) {
            hostedFacet.ingestAsset(context.getRequest().getPayload());
            return HttpResponses.created();
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD"});
    }

    private Response doGet(String path, OrientAptFacet aptFacet) throws IOException {
        Optional<Content> content = aptFacet.get(path);
        return content.map(HttpResponses::ok).orElseGet(() -> HttpResponses.notFound((String)path));
    }

    private String assetPath(Context context) {
        return ((AptSnapshotHandler.State)context.getAttributes().require(AptSnapshotHandler.State.class)).assetPath;
    }
}

