/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal.hosted;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningFacet;
import org.sonatype.nexus.repository.apt.internal.hosted.AssetAction;
import org.sonatype.nexus.repository.apt.internal.hosted.CompressingTempFileStore;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class OrientAptHostedFacet
extends FacetSupport {
    private static final String P_INDEX_SECTION = "index_section";
    private static final String P_ARCHITECTURE = "architecture";
    private static final String P_PACKAGE_NAME = "package_name";
    private static final String P_PACKAGE_VERSION = "package_version";
    private static final String SELECT_HOSTED_ASSETS = "SELECT name, attributes.apt.index_section AS index_section, attributes.apt.architecture AS architecture FROM asset WHERE bucket=:bucket AND attributes.apt.asset_kind=:asset_kind";

    public Asset ingestAsset(Payload body) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(body, AptFacetHelper.hashAlgorithms);){
            ControlFile control = AptPackageParser.parsePackageInfo((InputStreamSupplier)tempBlob).getControlFile();
            if (control == null) {
                throw new IllegalOperationException("Invalid Debian package supplied");
            }
            return this.ingestAsset(control, tempBlob, body.getSize(), body.getContentType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Asset ingestAsset(ControlFile control, TempBlob body, long size, String contentType) throws IOException {
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        PackageInfo info = new PackageInfo(control);
        String name = info.getPackageName();
        String version = info.getVersion();
        String architecture = info.getArchitecture();
        String assetPath = AptFacetHelper.buildAssetPath(name, version, architecture);
        Content content = aptFacet.put(assetPath, (Payload)new StreamPayload((InputStreamSupplier)body, size, contentType), info);
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)bucket, (Content)content);
        String indexSection = this.buildIndexSection(control, asset.size(), asset.getChecksums(AptFacetHelper.hashAlgorithms), assetPath);
        asset.formatAttributes().set(P_ARCHITECTURE, (Object)architecture);
        asset.formatAttributes().set(P_PACKAGE_NAME, (Object)name);
        asset.formatAttributes().set(P_PACKAGE_VERSION, (Object)version);
        asset.formatAttributes().set(P_INDEX_SECTION, (Object)indexSection);
        asset.formatAttributes().set("asset_kind", (Object)"DEB");
        tx.saveAsset(asset);
        this.rebuildIndexes(Collections.singletonList(new AssetChange(AssetAction.ADDED, asset)));
        return asset;
    }

    public void rebuildIndexes() throws IOException {
        this.rebuildIndexes(Collections.emptyList());
    }

    @TransactionalStoreMetadata
    public void rebuildIndexes(List<AssetChange> changes) throws IOException {
        String releaseFile;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        AptSigningFacet signingFacet = (AptSigningFacet)this.getRepository().facet(AptSigningFacet.class);
        Bucket bucket = tx.findBucket(this.getRepository());
        StringBuilder sha256Builder = new StringBuilder();
        StringBuilder md5Builder = new StringBuilder();
        Throwable throwable = null;
        Object var10_10 = null;
        try (CompressingTempFileStore store = this.buildPackageIndexes(tx, bucket, changes);){
            for (Map.Entry<String, CompressingTempFileStore.FileMetadata> entry : store.getFiles().entrySet()) {
                Content plainContent = aptFacet.put(this.packageIndexName(entry.getKey(), ""), (Payload)new StreamPayload(entry.getValue().plainSupplier(), entry.getValue().plainSize(), "text/plain"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, plainContent, this.packageRelativeIndexName(entry.getKey(), ""));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, plainContent, this.packageRelativeIndexName(entry.getKey(), ""));
                Content gzContent = aptFacet.put(this.packageIndexName(entry.getKey(), ".gz"), (Payload)new StreamPayload(entry.getValue().gzSupplier(), entry.getValue().bzSize(), "application/gzip"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, gzContent, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, gzContent, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                Content bzContent = aptFacet.put(this.packageIndexName(entry.getKey(), ".bz2"), (Payload)new StreamPayload(entry.getValue().bzSupplier(), entry.getValue().bzSize(), "application/bzip2"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, bzContent, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, bzContent, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
            }
            releaseFile = this.buildReleaseFile(aptFacet.getDistribution(), store.getFiles().keySet(), md5Builder.toString(), sha256Builder.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        aptFacet.put(this.releaseIndexName("Release"), (Payload)new BytesPayload(releaseFile.getBytes(Charsets.UTF_8), "text/plain"));
        byte[] inRelease = signingFacet.signInline(releaseFile);
        aptFacet.put(this.releaseIndexName("InRelease"), (Payload)new BytesPayload(inRelease, "text/plain"));
        byte[] releaseGpg = signingFacet.signExternal(releaseFile);
        aptFacet.put(this.releaseIndexName("Release.gpg"), (Payload)new BytesPayload(releaseGpg, "application/pgp-signature"));
    }

    private String buildReleaseFile(String distribution, Collection<String> architectures, String md5, String sha256) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz", (TimeZone)TimeZone.getTimeZone("GMT"));
        ControlFile.Paragraph p = new ControlFile.Paragraph(Arrays.asList(new ControlFile.ControlField("Suite", distribution), new ControlFile.ControlField("Codename", distribution), new ControlFile.ControlField("Components", "main"), new ControlFile.ControlField("Date", date), new ControlFile.ControlField("Architectures", String.join((CharSequence)" ", architectures)), new ControlFile.ControlField("SHA256", sha256), new ControlFile.ControlField("MD5Sum", md5)));
        return p.toString();
    }

    /*
     * Unable to fully structure code
     */
    private CompressingTempFileStore buildPackageIndexes(StorageTx tx, Bucket bucket, List<AssetChange> changes) throws IOException {
        result = new CompressingTempFileStore();
        streams = new HashMap<String, Writer>();
        ok = false;
        try {
            sqlParams = new HashMap<String, Object>();
            sqlParams.put("bucket", AttachedEntityHelper.id((Entity)bucket));
            sqlParams.put("asset_kind", "DEB");
            excludeNames = changes.stream().map((Function<AssetChange, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet$AssetChange ), (Lorg/sonatype/nexus/repository/apt/orient/internal/hosted/OrientAptHostedFacet$AssetChange;)Ljava/lang/String;)()).collect(Collectors.toSet());
            browse = tx.browse("SELECT name, attributes.apt.index_section AS index_section, attributes.apt.architecture AS architecture FROM asset WHERE bucket=:bucket AND attributes.apt.asset_kind=:asset_kind", sqlParams);
            for (ODocument document : browse) {
                name = (String)document.field("name", String.class);
                arch = (String)document.field("architecture", String.class);
                outWriter = streams.computeIfAbsent(arch, (Function<String, Writer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, openOutput(java.lang.String ), (Ljava/lang/String;)Ljava/io/Writer;)((CompressingTempFileStore)result));
                if (excludeNames.contains(name)) continue;
                indexSection = (String)document.field("index_section", String.class);
                outWriter.write(indexSection);
                outWriter.write("\n\n");
            }
            addAssets = changes.stream().filter((Predicate<AssetChange>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet$AssetChange ), (Lorg/sonatype/nexus/repository/apt/orient/internal/hosted/OrientAptHostedFacet$AssetChange;)Z)()).map((Function<AssetChange, Asset>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(org.sonatype.nexus.repository.apt.orient.internal.hosted.OrientAptHostedFacet$AssetChange ), (Lorg/sonatype/nexus/repository/apt/orient/internal/hosted/OrientAptHostedFacet$AssetChange;)Lorg/sonatype/nexus/repository/storage/Asset;)()).collect(Collectors.toList());
            for (Asset asset : addAssets) {
                arch = (String)asset.formatAttributes().get("architecture", String.class);
                indexSection = (String)asset.formatAttributes().get("index_section", String.class);
                outWriter = streams.computeIfAbsent(arch, (Function<String, Writer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, openOutput(java.lang.String ), (Ljava/lang/String;)Ljava/io/Writer;)((CompressingTempFileStore)result));
                outWriter.write(indexSection);
                outWriter.write("\n\n");
            }
            ok = true;
        }
        finally {
            ** for (writer : streams.values())
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((Writer)writer);
            continue;
        }
lbl41:
        // 1 sources

        if (!ok) {
            result.close();
        }
        return result;
    }

    private String buildIndexSection(ControlFile cf, long size, Map<HashAlgorithm, HashCode> hashes, String assetPath) {
        ControlFile.Paragraph modified = cf.getParagraphs().get(0).withFields(Arrays.asList(new ControlFile.ControlField("Filename", assetPath), new ControlFile.ControlField("Size", Long.toString(size)), new ControlFile.ControlField("MD5Sum", hashes.get(HashAlgorithm.MD5).toString()), new ControlFile.ControlField("SHA1", hashes.get(HashAlgorithm.SHA1).toString()), new ControlFile.ControlField("SHA256", hashes.get(HashAlgorithm.SHA256).toString())));
        return modified.toString();
    }

    private String releaseIndexName(String name) {
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        String dist = aptFacet.getDistribution();
        return "dists/" + dist + "/" + name;
    }

    private String packageIndexName(String arch, String ext) {
        OrientAptFacet aptFacet = (OrientAptFacet)this.getRepository().facet(OrientAptFacet.class);
        String dist = aptFacet.getDistribution();
        return "dists/" + dist + "/main/binary-" + arch + "/Packages" + ext;
    }

    private String packageRelativeIndexName(String arch, String ext) {
        return "main/binary-" + arch + "/Packages" + ext;
    }

    private void addSignatureItem(StringBuilder builder, HashAlgorithm algo, Content content, String filename) {
        Map hashMap = (Map)content.getAttributes().get("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP);
        builder.append("\n ");
        builder.append(((HashCode)hashMap.get(algo)).toString());
        builder.append(" ");
        builder.append(content.getSize());
        builder.append(" ");
        builder.append(filename);
    }

    private static /* synthetic */ String lambda$0(AssetChange change) {
        return change.asset.name();
    }

    private static /* synthetic */ boolean lambda$2(AssetChange change) {
        return change.action == AssetAction.ADDED;
    }

    private static /* synthetic */ Asset lambda$3(AssetChange change) {
        return change.asset;
    }

    public static class AssetChange {
        final AssetAction action;
        public final Asset asset;

        public AssetChange(AssetAction action, Asset asset) {
            this.action = action;
            this.asset = asset;
        }
    }
}

