/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.debian.Utils;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.apt.orient.AptRestoreFacet;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.internal.OrientFacetHelper;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientAptRestoreFacetImpl
extends FacetSupport
implements AptRestoreFacet {
    @Override
    @TransactionalStoreBlob
    public Content restore(AssetBlob assetBlob, String path) throws IOException {
        Asset asset;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientAptFacet aptFacet = (OrientAptFacet)this.facet(OrientAptFacet.class);
        if (Utils.isDebPackageContentType(path)) {
            ControlFile controlFile = AptPackageParser.parsePackageInfo(() -> assetBlob.getBlob().getInputStream()).getControlFile();
            asset = aptFacet.findOrCreateDebAsset(tx, path, new PackageInfo(controlFile));
        } else {
            asset = aptFacet.findOrCreateMetadataAsset(tx, path);
        }
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)new AttributesMap()));
        tx.saveAsset(asset);
        return OrientFacetHelper.toContent(asset, assetBlob.getBlob());
    }

    @Override
    @TransactionalTouchBlob
    public boolean assetExists(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository())) != null;
    }

    @Override
    public Query getComponentQuery(Blob blob) throws IOException {
        InputStream inputStream = blob.getInputStream();
        PackageInfo packageInfo = AptPackageParser.parsePackageInfo(() -> inputStream);
        return Query.builder().where("name").eq((Object)packageInfo.getPackageName()).and("version").eq((Object)packageInfo.getVersion()).and("group").eq((Object)packageInfo.getArchitecture()).build();
    }

    @Override
    public boolean componentRequired(String name) {
        return Utils.isDebPackageContentType(name);
    }
}

