/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.orient.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.debian.Utils;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.apt.orient.OrientAptFacet;
import org.sonatype.nexus.repository.apt.orient.OrientAptWritePolicySelector;
import org.sonatype.nexus.repository.apt.orient.internal.OrientFacetHelper;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientAptFacetImpl
extends FacetSupport
implements OrientAptFacet {
    @VisibleForTesting
    static final String CONFIG_KEY = "apt";
    private Config config;

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[]{Default.class, this.getRepository().getType().getValidationGroup()});
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new OrientAptWritePolicySelector());
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    @Override
    public String getDistribution() {
        return this.config.distribution;
    }

    @Override
    public boolean isFlat() {
        return this.config.flat;
    }

    @Override
    @TransactionalTouchBlob
    public Optional<Content> get(String path) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Optional.empty();
        }
        return Optional.of(OrientFacetHelper.toContent(asset, tx.requireBlob(asset.requireBlobRef())));
    }

    @Override
    @TransactionalStoreBlob
    public Content put(String path, Payload content) throws IOException {
        return this.put(path, content, null);
    }

    @Override
    @TransactionalStoreBlob
    public Content put(String path, Payload content, PackageInfo info) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, AptFacetHelper.hashAlgorithms);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset asset = Utils.isDebPackageContentType(path) ? this.findOrCreateDebAsset(tx, path, info != null ? info : AptPackageParser.parsePackageInfo(() -> tempBlob.getBlob().getInputStream())) : this.findOrCreateMetadataAsset(tx, path);
            AttributesMap contentAttributes = null;
            if (content instanceof Content) {
                contentAttributes = ((Content)content).getAttributes();
            }
            Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
            AssetBlob blob = tx.setBlob(asset, path, (InputStreamSupplier)tempBlob, AptFacetHelper.hashAlgorithms, null, content.getContentType(), false);
            tx.saveAsset(asset);
            return OrientFacetHelper.toContent(asset, blob.getBlob());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Asset findOrCreateDebAsset(StorageTx tx, String path, PackageInfo packageInfo) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = tx.findAssetWithProperty("name", (Object)path, bucket);
        if (asset == null) {
            Component component = this.findOrCreateComponent(tx, bucket, packageInfo);
            asset = (Asset)tx.createAsset(bucket, component).name(path);
        }
        return asset;
    }

    @Override
    public Asset findOrCreateMetadataAsset(StorageTx tx, String path) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = tx.findAssetWithProperty("name", (Object)path, bucket);
        return asset != null ? asset : (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(path);
    }

    private Component findOrCreateComponent(StorageTx tx, Bucket bucket, PackageInfo info) {
        String name = info.getPackageName();
        String version = info.getVersion();
        String architecture = info.getArchitecture();
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).and("group").eq((Object)architecture).build(), Collections.singletonList(this.getRepository()));
        Component component = (Component)Iterables.getFirst((Iterable)components, null);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(version).group(architecture);
            tx.saveComponent(component);
        }
        return component;
    }

    @Override
    @TransactionalDeleteBlob
    public boolean delete(String path) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)path, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            return false;
        }
        tx.deleteAsset(asset);
        return true;
    }

    @VisibleForTesting
    static class Config {
        @NotNull(groups={HostedType.ValidationGroup.class, ProxyType.ValidationGroup.class})
        public String distribution;
        @NotNull(groups={ProxyType.ValidationGroup.class})
        public boolean flat;

        Config() {
        }
    }
}

