/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.snapshot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.Release;
import org.sonatype.nexus.repository.apt.internal.snapshot.SnapshotComponentSelector;

public class FilteredSnapshotComponentSelector
implements SnapshotComponentSelector {
    private final ControlFile settings;

    public FilteredSnapshotComponentSelector(ControlFile settings) {
        this.settings = settings;
    }

    @Override
    public List<String> getArchitectures(Release release) {
        Optional<Set> settingsArchitectures = this.settings.getField("Architectures").map(s -> s.listValue()).map(l -> new HashSet(l));
        if (settingsArchitectures.isPresent()) {
            HashSet<String> releaseArchitectures = new HashSet<String>(release.getArchitectures());
            releaseArchitectures.retainAll(settingsArchitectures.get());
            return new ArrayList<String>(releaseArchitectures);
        }
        return release.getArchitectures();
    }

    @Override
    public List<String> getComponents(Release release) {
        Optional<Set> settingsComponents = this.settings.getField("Components").map(s -> s.listValue()).map(l -> new HashSet(l));
        if (settingsComponents.isPresent()) {
            HashSet<String> releaseComponents = new HashSet<String>(release.getComponents());
            releaseComponents.retainAll(settingsComponents.get());
            return new ArrayList<String>(releaseComponents);
        }
        return release.getComponents();
    }
}

