/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.gpg;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.security.GpgUtils;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named
@Facet.Exposed
public class AptSigningFacet
extends FacetSupport {
    @VisibleForTesting
    static final String CONFIG_KEY = "aptSigning";
    private Config config;

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[]{Default.class, this.getRepository().getType().getValidationGroup()});
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    public Content getPublicKey() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PGPPublicKey publicKey = GpgUtils.getPublicKey((String)this.config.keypair);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BCPGOutputStream os = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)buffer));){
            publicKey.encode((OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new Content((Payload)new BytesPayload(buffer.toByteArray(), "application/pgp"));
    }

    public byte[] signInline(String input) throws IOException {
        return GpgUtils.signInline((String)input, (String)this.config.keypair, (String)this.config.passphrase);
    }

    public byte[] signExternal(String input) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = IOUtils.toInputStream((String)input, (Charset)StandardCharsets.UTF_8);){
            return GpgUtils.signExternal((InputStream)is, (String)this.config.keypair, (String)this.config.passphrase);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    static class Config {
        @NotNull(groups={HostedType.ValidationGroup.class, GroupType.ValidationGroup.class})
        public String keypair;
        public String passphrase = "";

        Config() {
        }
    }
}

