/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.debian;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;

public class Release {
    private final ControlFile index;

    public Release(ControlFile index) {
        this.index = index;
    }

    public Optional<String> getOrigin() {
        return this.getValue("Origin");
    }

    public Optional<String> getLabel() {
        return this.getValue("Label");
    }

    public Optional<String> getSuite() {
        return this.getValue("Suite");
    }

    public Optional<String> getVersion() {
        return this.getValue("Version");
    }

    public Optional<String> getCodename() {
        return this.getValue("Codename");
    }

    public List<String> getComponents() {
        return this.index.getField("Components").map(s -> s.listValue()).orElse(Collections.emptyList());
    }

    public List<String> getArchitectures() {
        return this.index.getField("Architectures").map(s -> s.listValue()).orElse(Collections.emptyList());
    }

    public Optional<String> getDescription() {
        return this.getValue("Description");
    }

    private Optional<String> getValue(String name) {
        return this.index.getField(name).map(e -> e.value);
    }
}

