/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.debian;

import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;

public class PackageInfo {
    private static final String PACKAGE_FIELD = "Package";
    private static final String VERSION_FIELD = "Version";
    private static final String ARCHITECTURE_FIELD = "Architecture";
    private final ControlFile controlFile;

    public PackageInfo(ControlFile controlFile) {
        this.controlFile = controlFile;
    }

    public ControlFile getControlFile() {
        return this.controlFile;
    }

    public String getPackageName() {
        return this.getField(PACKAGE_FIELD);
    }

    public String getVersion() {
        return this.getField(VERSION_FIELD);
    }

    public String getArchitecture() {
        return this.getField(ARCHITECTURE_FIELD);
    }

    private String getField(String fieldName) {
        return this.controlFile.getField(fieldName).map(f -> f.value).get();
    }
}

