/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal.debian;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ControlFile {
    private final List<Paragraph> paragraphs;

    public static Builder newBuilder() {
        return new Builder(new ArrayList());
    }

    public ControlFile(List<Paragraph> paragraphs) {
        this.paragraphs = new ArrayList<Paragraph>(paragraphs);
    }

    public Builder builder() {
        return new Builder(new ArrayList<Paragraph>(this.paragraphs));
    }

    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    public Optional<ControlField> getField(String name) {
        if (this.paragraphs.isEmpty()) {
            return Optional.empty();
        }
        return this.paragraphs.get(0).getField(name);
    }

    public List<ControlField> getFields() {
        if (this.paragraphs.isEmpty()) {
            return Collections.emptyList();
        }
        return this.paragraphs.get(0).getFields();
    }

    public static class Builder {
        private List<Paragraph> paragraphs;

        private Builder(List<Paragraph> paragraphs) {
            this.paragraphs = paragraphs;
        }

        public Builder removeParagraphs(Predicate<Paragraph> p) {
            this.paragraphs = this.paragraphs.stream().filter(p).collect(Collectors.toList());
            return this;
        }

        public Builder addParagraph(Paragraph p) {
            this.paragraphs.add(p);
            return this;
        }

        public Builder replaceParagraph(Predicate<Paragraph> predicate, Paragraph p) {
            this.paragraphs = Stream.concat(this.paragraphs.stream().filter(predicate), Stream.of(p)).collect(Collectors.toList());
            return this;
        }

        public Builder transformParagraphs(Predicate<Paragraph> predicate, Function<Paragraph, Paragraph> transform) {
            this.paragraphs = this.paragraphs.stream().filter(predicate).map(transform).collect(Collectors.toList());
            return this;
        }

        public ControlFile build() {
            return new ControlFile(this.paragraphs);
        }
    }

    public static class ControlField {
        public final String key;
        public final String value;

        public ControlField(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String foldedValue() {
            return Arrays.stream(this.value.split("\n")).map(s -> s.trim()).collect(Collectors.joining());
        }

        public List<String> listValue() {
            return Arrays.asList(this.value.trim().split("\\s+"));
        }
    }

    public static class Paragraph {
        private final List<ControlField> fields;

        public Paragraph(List<ControlField> fields) {
            this.fields = new ArrayList<ControlField>(fields);
        }

        public Optional<ControlField> getField(String name) {
            for (ControlField f : this.fields) {
                if (!f.key.equals(name)) continue;
                return Optional.of(f);
            }
            return Optional.empty();
        }

        public List<ControlField> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        public Paragraph withFields(List<ControlField> updateFields) {
            Map<String, ControlField> index = updateFields.stream().collect(Collectors.toMap(f -> f.key, f -> f));
            return new Paragraph(Stream.concat(this.fields.stream().filter(f -> !index.containsKey(f.key)), updateFields.stream()).collect(Collectors.toList()));
        }

        public String toString() {
            return this.fields.stream().map(f -> String.valueOf(f.key) + ": " + f.value).collect(Collectors.joining("\n"));
        }
    }
}

