/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named(value="apt")
@Singleton
public class AptContentValidator
extends ComponentSupport
implements ContentValidator {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TXT = ".txt";
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public AptContentValidator(DefaultContentValidator defaultContentValidator) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, InputStreamSupplier contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        String name = contentName;
        if (name != null && Objects.equals(declaredContentType, TEXT_PLAIN)) {
            name = String.valueOf(name) + TXT;
        }
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, name, declaredContentType);
    }
}

