/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.hosted;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AptHostedFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange;
import org.sonatype.nexus.repository.apt.internal.hosted.AssetAction;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.LastAssetMaintenanceFacet;

@Named
public class AptLastAssetMaintenanceFacet
extends LastAssetMaintenanceFacet {
    public Set<String> deleteAsset(Asset asset) {
        Set deleteAssetPaths = super.deleteAsset(asset);
        FluentAsset fluentAsset = this.contentFacet().assets().with(asset);
        this.rebuildMetadata(Collections.singletonList(fluentAsset));
        return deleteAssetPaths;
    }

    public Set<String> deleteComponent(Component component) {
        FluentComponent fluentComponent = this.contentFacet().components().with(component);
        Set deleteAssetPaths = super.deleteComponent(component);
        this.rebuildMetadata(fluentComponent.assets());
        return deleteAssetPaths;
    }

    private void rebuildMetadata(Collection<FluentAsset> fluentAssets) {
        try {
            List<AssetChange> assetChanges = fluentAssets.stream().map(fluentAsset -> new AssetChange(AssetAction.REMOVED, (FluentAsset)fluentAsset)).collect(Collectors.toList());
            ((AptHostedFacet)this.getRepository().facet(AptHostedFacet.class)).rebuildMetadata(assetChanges);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

