/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.hosted;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.apt.internal.gpg.AptSigningFacet;
import org.sonatype.nexus.repository.apt.internal.hosted.AssetAction;
import org.sonatype.nexus.repository.apt.internal.hosted.CompressingTempFileStore;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Named
@Facet.Exposed
public class AptHostedFacet
extends FacetSupport {
    public FluentAsset put(String assetPath, Payload payload, PackageInfo packageInfo) throws IOException {
        Preconditions.checkNotNull((Object)assetPath);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)packageInfo);
        AptContentFacet contentFacet = (AptContentFacet)this.getRepository().facet(AptContentFacet.class);
        FluentAsset asset = contentFacet.put(assetPath, payload, packageInfo);
        this.rebuildMetadata(Collections.singletonList(new AssetChange(AssetAction.ADDED, asset)));
        return asset;
    }

    public void rebuildMetadata() throws IOException {
        this.rebuildMetadata(Collections.emptyList());
    }

    public void rebuildMetadata(List<AssetChange> changeList) throws IOException {
        String releaseFile;
        AptContentFacet aptFacet = (AptContentFacet)this.getRepository().facet(AptContentFacet.class);
        AptSigningFacet signingFacet = (AptSigningFacet)this.getRepository().facet(AptSigningFacet.class);
        StringBuilder sha256Builder = new StringBuilder();
        StringBuilder md5Builder = new StringBuilder();
        Throwable throwable = null;
        Object var8_8 = null;
        try (CompressingTempFileStore store = this.buildPackageIndexes(changeList);){
            for (Map.Entry<String, CompressingTempFileStore.FileMetadata> entry : store.getFiles().entrySet()) {
                FluentAsset metadataAsset = aptFacet.put(this.packageIndexName(entry.getKey(), ""), (Payload)new StreamPayload(entry.getValue().plainSupplier(), entry.getValue().plainSize(), "text/plain"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, metadataAsset, this.packageRelativeIndexName(entry.getKey(), ""));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, metadataAsset, this.packageRelativeIndexName(entry.getKey(), ""));
                FluentAsset gzMetadataAsset = aptFacet.put(this.packageIndexName(entry.getKey(), ".gz"), (Payload)new StreamPayload(entry.getValue().gzSupplier(), entry.getValue().bzSize(), "application/gzip"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, gzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, gzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".gz"));
                FluentAsset bzMetadataAsset = aptFacet.put(this.packageIndexName(entry.getKey(), ".bz2"), (Payload)new StreamPayload(entry.getValue().bzSupplier(), entry.getValue().bzSize(), "application/bzip2"));
                this.addSignatureItem(md5Builder, HashAlgorithm.MD5, bzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
                this.addSignatureItem(sha256Builder, HashAlgorithm.SHA256, bzMetadataAsset, this.packageRelativeIndexName(entry.getKey(), ".bz2"));
            }
            releaseFile = this.buildReleaseFile(aptFacet.getDistribution(), store.getFiles().keySet(), md5Builder.toString(), sha256Builder.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        aptFacet.put(this.releaseIndexName("Release"), (Payload)new BytesPayload(releaseFile.getBytes(Charsets.UTF_8), "text/plain"));
        byte[] inRelease = signingFacet.signInline(releaseFile);
        aptFacet.put(this.releaseIndexName("InRelease"), (Payload)new BytesPayload(inRelease, "text/plain"));
        byte[] releaseGpg = signingFacet.signExternal(releaseFile);
        aptFacet.put(this.releaseIndexName("Release.gpg"), (Payload)new BytesPayload(releaseGpg, "application/pgp-signature"));
    }

    /*
     * Unable to fully structure code
     */
    private CompressingTempFileStore buildPackageIndexes(List<AssetChange> changes) throws IOException {
        result = new CompressingTempFileStore();
        streams = new HashMap<String, Writer>();
        ok = false;
        try {
            architectures = changes.stream().map((Function<AssetChange, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange ), (Lorg/sonatype/nexus/repository/apt/datastore/internal/hosted/AssetChange;)Ljava/lang/String;)((AptHostedFacet)this)).collect(Collectors.toSet());
            allAssets = ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().byKind("DEB").browse(0x7FFFFFFF, null);
            allAssets.stream().map((Function<FluentAsset, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getArchitecture(org.sonatype.nexus.repository.content.fluent.FluentAsset ), (Lorg/sonatype/nexus/repository/content/fluent/FluentAsset;)Ljava/lang/String;)((AptHostedFacet)this)).collect(Collectors.toCollection((Supplier<Set>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$2(java.util.Set ), ()Ljava/util/Set;)(architectures)));
            assetsPerArch = new HashMap<String, List<T>>();
            for (String architecture : architectures) {
                assets = allAssets.stream().filter((Predicate<FluentAsset>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(java.lang.String org.sonatype.nexus.repository.content.fluent.FluentAsset ), (Lorg/sonatype/nexus/repository/content/fluent/FluentAsset;)Z)((AptHostedFacet)this, (String)architecture)).collect(Collectors.toList());
                assetsPerArch.put(architecture, assets);
            }
            for (List assets : assetsPerArch.values()) {
                removeAssetChange = changes.stream().filter((Predicate<AssetChange>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$4(org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange ), (Lorg/sonatype/nexus/repository/apt/datastore/internal/hosted/AssetChange;)Z)()).filter((Predicate<AssetChange>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$5(org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange ), (Lorg/sonatype/nexus/repository/apt/datastore/internal/hosted/AssetChange;)Z)()).findAny();
                if (assets.isEmpty() && removeAssetChange.isPresent()) {
                    this.createEmptyMetadataFile(result, streams, removeAssetChange.get());
                    continue;
                }
                this.createMetadataFileWithData(changes, result, streams, assets);
            }
            ok = true;
        }
        finally {
            ** for (writer : streams.values())
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((Writer)writer);
            continue;
        }
lbl28:
        // 1 sources

        if (!ok) {
            result.close();
        }
        return result;
    }

    private String getArchitecture(FluentAsset asset) {
        return (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)asset).get("architecture");
    }

    private void createEmptyMetadataFile(CompressingTempFileStore result, Map<String, Writer> streams, AssetChange removeAssetChange) {
        String arch = (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)removeAssetChange.getAsset()).get("architecture");
        streams.computeIfAbsent(arch, result::openOutput);
    }

    private void createMetadataFileWithData(List<AssetChange> changes, CompressingTempFileStore result, Map<String, Writer> streams, List<FluentAsset> assets) throws IOException {
        String arch;
        Set excludeNames = changes.stream().map(c -> c.getAsset().path()).collect(Collectors.toSet());
        for (FluentAsset asset : assets) {
            String name = asset.path();
            arch = (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)asset).get("architecture");
            Writer outWriter = streams.computeIfAbsent(arch, result::openOutput);
            if (excludeNames.contains(name)) continue;
            String indexSection = (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)asset).get("index_section");
            outWriter.write(indexSection);
            outWriter.write("\n\n");
        }
        List addAssets = changes.stream().filter(c -> c.getAction() == AssetAction.ADDED).map(AssetChange::getAsset).collect(Collectors.toList());
        for (FluentAsset asset : addAssets) {
            arch = (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)asset).get("architecture");
            String indexSection = (String)FormatAttributesUtils.getFormatAttributes((FluentAsset)asset).get("index_section");
            Writer outWriter = streams.computeIfAbsent(arch, result::openOutput);
            outWriter.write(indexSection);
            outWriter.write("\n\n");
        }
    }

    private String buildReleaseFile(String distribution, Collection<String> architectures, String md5, String sha256) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz", (TimeZone)TimeZone.getTimeZone("GMT"));
        ControlFile.Paragraph p = new ControlFile.Paragraph(Arrays.asList(new ControlFile.ControlField("Suite", distribution), new ControlFile.ControlField("Codename", distribution), new ControlFile.ControlField("Components", "main"), new ControlFile.ControlField("Date", date), new ControlFile.ControlField("Architectures", String.join((CharSequence)" ", architectures)), new ControlFile.ControlField("SHA256", sha256), new ControlFile.ControlField("MD5Sum", md5)));
        return p.toString();
    }

    private String releaseIndexName(String name) {
        AptContentFacet aptFacet = (AptContentFacet)this.getRepository().facet(AptContentFacet.class);
        String dist = aptFacet.getDistribution();
        return "dists/" + dist + "/" + name;
    }

    private String packageIndexName(String arch, String ext) {
        AptContentFacet aptFacet = (AptContentFacet)this.getRepository().facet(AptContentFacet.class);
        String dist = aptFacet.getDistribution();
        return "dists/" + dist + "/main/binary-" + arch + "/Packages" + ext;
    }

    private String packageRelativeIndexName(String arch, String ext) {
        return "main/binary-" + arch + "/Packages" + ext;
    }

    private void addSignatureItem(StringBuilder builder, HashAlgorithm algo, FluentAsset asset, String filename) {
        AssetBlob assetBlob = (AssetBlob)asset.blob().orElseThrow(() -> new IllegalStateException("Cannot generate signature for metadata. Blob couldn't be found for asset: " + filename));
        builder.append("\n ");
        builder.append((String)assetBlob.checksums().get(algo.name()));
        builder.append(" ");
        builder.append(assetBlob.blobSize());
        builder.append(" ");
        builder.append(filename);
    }

    private /* synthetic */ String lambda$0(AssetChange change) {
        return this.getArchitecture(change.getAsset());
    }

    private static /* synthetic */ Set lambda$2(Set set) {
        return set;
    }

    private /* synthetic */ boolean lambda$3(String string, FluentAsset asset) {
        return this.getArchitecture(asset).equals(string);
    }

    private static /* synthetic */ boolean lambda$4(AssetChange change) {
        return change.getAsset().kind().equals("DEB");
    }

    private static /* synthetic */ boolean lambda$5(AssetChange change) {
        return change.getAction() == AssetAction.REMOVED;
    }
}

