/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.debian.Utils;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Facet.Exposed
@Named(value="apt")
public class AptContentFacetImpl
extends ContentFacetSupport
implements AptContentFacet {
    @VisibleForTesting
    static final String CONFIG_KEY = "apt";
    private Config config;

    @Inject
    public AptContentFacetImpl(@Named(value="apt") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy writePolicy = super.writePolicy(asset);
        if (WritePolicy.ALLOW_ONCE == writePolicy) {
            String name = asset.path();
            if (name.endsWith(".deb")) {
                return WritePolicy.ALLOW_ONCE;
            }
            return WritePolicy.ALLOW;
        }
        return writePolicy;
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("APT config: {}", (Object)this.config);
    }

    @Override
    public String getDistribution() {
        return this.config.distribution;
    }

    @Override
    public boolean isFlat() {
        return this.config.flat;
    }

    @Override
    public Optional<FluentAsset> getAsset(String path) {
        return this.assets().path(AptFacetHelper.normalizeAssetPath(path)).find();
    }

    @Override
    public Optional<Content> get(String assetPath) {
        return this.assets().path(AptFacetHelper.normalizeAssetPath(assetPath)).find().map(FluentAsset::download);
    }

    @Override
    public FluentAsset put(String path, Payload content) throws IOException {
        return this.put(path, content, null);
    }

    @Override
    public FluentAsset put(String path, Payload payload, @Nullable PackageInfo packageInfo) throws IOException {
        String normalizedPath = AptFacetHelper.normalizeAssetPath(path);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, AptFacetHelper.hashAlgorithms);){
            FluentAsset fluentAsset = Utils.isDebPackageContentType(normalizedPath) ? this.findOrCreateDebAsset(normalizedPath, tempBlob, packageInfo) : this.findOrCreateMetadataAsset(tempBlob, normalizedPath);
            return fluentAsset;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentAsset findOrCreateDebAsset(String path, TempBlob tempBlob, @Nullable PackageInfo packageInfo) throws IOException {
        if (packageInfo == null) {
            packageInfo = AptPackageParser.parsePackageInfo((InputStreamSupplier)tempBlob);
        }
        FluentAsset asset = this.assets().path(AptFacetHelper.normalizeAssetPath(path)).kind("DEB").component((Component)this.findOrCreateComponent(packageInfo)).blob(tempBlob).save();
        ControlFile controlFile = packageInfo.getControlFile();
        this.populateAttributes(packageInfo, asset, controlFile);
        return asset;
    }

    private void populateAttributes(PackageInfo info, FluentAsset asset, ControlFile controlFile) {
        HashMap<String, String> formatAttributes = new HashMap<String, String>();
        formatAttributes.put("architecture", info.getArchitecture());
        formatAttributes.put("package_name", info.getPackageName());
        formatAttributes.put("package_version", info.getVersion());
        formatAttributes.put("index_section", this.buildIndexSection(controlFile, asset));
        FormatAttributesUtils.setFormatAttributes((FluentAsset)asset, formatAttributes);
    }

    private String buildIndexSection(ControlFile controlFile, FluentAsset asset) {
        AssetBlob assetBlob = (AssetBlob)asset.blob().orElseThrow(() -> new IllegalStateException("Impossible build index_section. Asset blob couldn't be found for asset: " + asset.path()));
        Map checksums = assetBlob.checksums();
        return controlFile.getParagraphs().get(0).withFields(Arrays.asList(new ControlFile.ControlField("Filename", asset.path()), new ControlFile.ControlField("Size", Long.toString(assetBlob.blobSize())), new ControlFile.ControlField("MD5Sum", (String)checksums.get(HashAlgorithm.MD5.name())), new ControlFile.ControlField("SHA1", (String)checksums.get(HashAlgorithm.SHA1.name())), new ControlFile.ControlField("SHA256", (String)checksums.get(HashAlgorithm.SHA256.name())))).toString();
    }

    @Override
    public FluentAsset findOrCreateMetadataAsset(TempBlob tempBlob, String path) {
        return this.assets().path(AptFacetHelper.normalizeAssetPath(path)).blob(tempBlob).save();
    }

    private FluentComponent findOrCreateComponent(PackageInfo info) {
        String name = info.getPackageName();
        String version = info.getVersion();
        String architecture = info.getArchitecture();
        return this.components().name(name).version(version).namespace(architecture).getOrCreate();
    }

    @Override
    public TempBlob getTempBlob(Payload payload) {
        Preconditions.checkNotNull((Object)payload);
        return this.blobs().ingest(payload, AptFacetHelper.hashAlgorithms);
    }

    @Override
    public TempBlob getTempBlob(InputStream in, @Nullable String contentType) {
        Preconditions.checkNotNull((Object)in);
        return this.blobs().ingest(in, contentType, AptFacetHelper.hashAlgorithms);
    }

    @Override
    public void deleteAssetsByPrefix(String pathPrefix) {
        String filter = "repository_id = #{filterParams.repositoryParam} AND path LIKE #{filterParams.pathParam} AND component_id IS NULL";
        ImmutableMap params = ImmutableMap.of((Object)"repositoryParam", (Object)this.contentRepositoryId(), (Object)"pathParam", (Object)(String.valueOf(pathPrefix) + "%"));
        Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.assets().byFilter(filter, (Map)params)).browse(arg_0, arg_1)).forEach(FluentAsset::delete);
    }

    static class Config {
        @NotNull(groups={HostedType.ValidationGroup.class, ProxyType.ValidationGroup.class})
        public String distribution;
        @NotNull(groups={ProxyType.ValidationGroup.class})
        public boolean flat;

        Config() {
        }
    }
}

