/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.apt.AptUploadHandlerSupport;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AptHostedFacet;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Singleton
@Named(value="apt")
public class AptUploadHandler
extends AptUploadHandlerSupport {
    @Inject
    public AptUploadHandler(@Named(value="simple") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(variableResolverAdapter, contentPermissionChecker, uploadDefinitionExtensions);
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        AptContentFacet aptContentFacet = (AptContentFacet)repository.facet(AptContentFacet.class);
        AptHostedFacet hostedFacet = (AptHostedFacet)repository.facet(AptHostedFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = aptContentFacet.getTempBlob((Payload)payload);){
            ControlFile controlFile = AptPackageParser.parsePackageInfo((InputStreamSupplier)tempBlob).getControlFile();
            String assetPath = AptFacetHelper.buildAssetPath(controlFile);
            Content content = hostedFacet.put(assetPath, (Payload)payload, new PackageInfo(controlFile)).markAsCached((Payload)payload).download();
            return new UploadResponse(Collections.singletonList(content), Collections.singletonList(assetPath));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

