/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt;

import java.util.Collections;
import java.util.Set;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;

public abstract class AptUploadHandlerSupport
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final VariableResolverAdapter variableResolverAdapter;
    private final ContentPermissionChecker contentPermissionChecker;

    public AptUploadHandlerSupport(VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.variableResolverAdapter = variableResolverAdapter;
        this.contentPermissionChecker = contentPermissionChecker;
    }

    protected void doValidation(Repository repository, String assetPath) {
        this.ensurePermitted(repository.getName(), "apt", assetPath, Collections.emptyMap());
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("apt", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

