/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.mime.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.sonatype.nexus.mime.MimeRule;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.mime.internal.NexusMimeTypes;

@Named
@Singleton
public class DefaultMimeSupport
implements MimeSupport {
    private final TikaConfig tikaConfig = TikaConfig.getDefaultConfig();
    private final Detector detector = this.tikaConfig.getDetector();
    private final LoadingCache<String, List<String>> extensionToMimeTypeCache;

    @Inject
    public DefaultMimeSupport() {
        this(new NexusMimeTypes());
    }

    @VisibleForTesting
    public DefaultMimeSupport(final NexusMimeTypes nexusMimeTypes) {
        this.extensionToMimeTypeCache = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new CacheLoader<String, List<String>>(){

            public List<String> load(String key) throws Exception {
                ArrayList detected = Lists.newArrayList();
                MimeRule mimeType = nexusMimeTypes.getMimeRuleForExtension(key);
                if (mimeType != null) {
                    detected.addAll(mimeType.getMimetypes());
                    if (mimeType.isOverride()) {
                        return detected;
                    }
                }
                Metadata metadata = new Metadata();
                metadata.set("resourceName", "dummy." + key);
                MediaType mediaType = DefaultMimeSupport.this.detector.detect(null, metadata);
                DefaultMimeSupport.this.unravel(detected, mediaType);
                return detected;
            }
        });
    }

    @Override
    @Nonnull
    public String guessMimeTypeFromPath(String path, MimeRulesSource ... mimeRulesSources) {
        return this.guessMimeTypesListFromPath(path, mimeRulesSources).get(0);
    }

    @Override
    @Nonnull
    public List<String> guessMimeTypesListFromPath(String path, MimeRulesSource ... mimeRulesSources) {
        Preconditions.checkNotNull((Object)path);
        ArrayList<String> mimeTypes = new ArrayList<String>();
        MimeRulesSource[] mimeRulesSourceArray = mimeRulesSources;
        int n = mimeRulesSources.length;
        int n2 = 0;
        while (n2 < n) {
            MimeRulesSource mimeRulesSource = mimeRulesSourceArray[n2];
            MimeRule mimeRule = mimeRulesSource.getRuleForName(path);
            if (mimeRule != null) {
                mimeTypes.addAll(mimeRule.getMimetypes());
                if (mimeRule.isOverride()) {
                    return mimeTypes;
                }
            }
            ++n2;
        }
        mimeTypes.addAll(this.guessMimeTypesListFromPath(path));
        return mimeTypes;
    }

    @Override
    @Nonnull
    public String detectMimeType(InputStream input, @Nullable String fileName) throws IOException {
        return this.detectMimeTypes(input, fileName).get(0);
    }

    @Override
    @Nonnull
    public List<String> detectMimeTypes(InputStream input, @Nullable String fileName) throws IOException {
        MediaType mediaType;
        Preconditions.checkNotNull((Object)input);
        ArrayList detected = Lists.newArrayList();
        Metadata metadata = new Metadata();
        if (fileName != null) {
            metadata.set("resourceName", fileName);
        }
        Throwable throwable = null;
        Object var7_7 = null;
        try (TikaInputStream tis = TikaInputStream.get((InputStream)input);){
            mediaType = this.detector.detect((InputStream)tis, metadata);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.unravel(detected, mediaType);
        if (detected.isEmpty()) {
            detected.add("application/octet-stream");
        }
        return detected;
    }

    @Nonnull
    private List<String> guessMimeTypesListFromPath(String path) {
        Preconditions.checkNotNull((Object)path);
        String pathExtension = Files.getFileExtension((String)path);
        try {
            ArrayList<String> mimeTypes = new ArrayList<String>();
            List extBasedTypes = (List)this.extensionToMimeTypeCache.get((Object)pathExtension);
            if (extBasedTypes != null && !extBasedTypes.isEmpty()) {
                mimeTypes.addAll(extBasedTypes);
            }
            if (mimeTypes.isEmpty()) {
                mimeTypes.add("application/octet-stream");
            }
            return mimeTypes;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void unravel(List<String> detected, MediaType mt) {
        detected.add(mt.getBaseType().toString());
        for (MediaType alias : this.tikaConfig.getMediaTypeRegistry().getAliases(mt)) {
            detected.add(alias.getBaseType().toString());
        }
        if (mt.getSubtype().endsWith("+xml") || mt.getSubtype().endsWith("+zip")) {
            detected.add(this.tikaConfig.getMediaTypeRegistry().getSupertype(mt).toString());
        }
    }
}

