/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.mime;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.sonatype.nexus.mime.MimeRule;
import org.sonatype.nexus.mime.MimeRulesSource;

public class RegexpMimeRulesSource
implements MimeRulesSource {
    private final LinkedHashMap<Pattern, MimeRule> rules = Maps.newLinkedHashMap();

    public void addRule(String pattern, String mimeType) {
        this.addRule(Pattern.compile(pattern), mimeType);
    }

    public void addRule(Pattern pattern, String mimeType) {
        this.rules.put((Pattern)Preconditions.checkNotNull((Object)pattern), new MimeRule(false, mimeType));
    }

    @Override
    public MimeRule getRuleForName(String name) {
        for (Map.Entry<Pattern, MimeRule> entry : this.rules.entrySet()) {
            if (!entry.getKey().matcher(name).matches()) continue;
            return entry.getValue();
        }
        return null;
    }
}

