/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.supportzip.ImportTaskData;
import org.sonatype.nexus.supportzip.datastore.RestoreHelper;

@Named
@Singleton
@Priority(value=0)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class TaskRestorer
extends StateGuardLifecycleSupport {
    private final RestoreHelper restoreHelper;
    private final Map<String, ImportTaskData> importTaskByName;

    @Inject
    public TaskRestorer(RestoreHelper restoreHelper, Map<String, ImportTaskData> importTaskByName) {
        this.restoreHelper = (RestoreHelper)((Object)Preconditions.checkNotNull((Object)((Object)restoreHelper)));
        this.importTaskByName = (Map)Preconditions.checkNotNull(importTaskByName);
    }

    protected void doStart() throws Exception {
        this.maybeRestore();
    }

    private void maybeRestore() throws IOException {
        Path dbDir = this.restoreHelper.getDbPath();
        for (Map.Entry<String, ImportTaskData> exporterEntry : this.importTaskByName.entrySet()) {
            String fileName = String.valueOf(exporterEntry.getKey()) + ".json";
            File file = dbDir.resolve(fileName).toFile();
            ImportTaskData importTask = exporterEntry.getValue();
            if (file.exists()) {
                importTask.restore(file);
                FileUtils.deleteQuietly((File)file);
                continue;
            }
            this.log.debug("Can't find {} file to restore data", (Object)file);
        }
    }
}

