/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip.datastore;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.io.SanitizingJsonOutputStream;
import org.sonatype.nexus.supportzip.PasswordSanitizing;
import org.sonatype.nexus.supportzip.datastore.SecondsDeserializer;
import org.sonatype.nexus.supportzip.datastore.SecondsSerializer;

@Named
@Singleton
public class JsonExporter
extends ComponentSupport {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String EMPTY_JSON = "{}";

    static {
        OBJECT_MAPPER.registerModule((Module)new SimpleModule().addSerializer(Time.class, (JsonSerializer)new SecondsSerializer()).addDeserializer(Time.class, (JsonDeserializer)new SecondsDeserializer()));
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.registerModule((Module)new JodaModule());
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void exportToJson(List<T> objects, File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        if (objects == null || objects.isEmpty()) {
            this.writeEmptyJson(file);
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes(objects));
            try {
                block19: {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        try (SanitizingJsonOutputStream stream = new SanitizingJsonOutputStream((OutputStream)os, PasswordSanitizing.SENSITIVE_FIELD_NAMES, "**REDACTED**");){
                            ByteStreams.copy((InputStream)is, (OutputStream)stream);
                        }
                        if (os == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (os == null) throw throwable;
                        ((OutputStream)os).close();
                        throw throwable;
                    }
                    ((OutputStream)os).close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void exportObjectToJson(T object, File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        if (object == null) {
            this.writeEmptyJson(file);
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes(object));
            try {
                block19: {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        try (SanitizingJsonOutputStream stream = new SanitizingJsonOutputStream((OutputStream)os, PasswordSanitizing.SENSITIVE_FIELD_NAMES, "**REDACTED**");){
                            ByteStreams.copy((InputStream)is, (OutputStream)stream);
                        }
                        if (os == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (os == null) throw throwable;
                        ((OutputStream)os).close();
                        throw throwable;
                    }
                    ((OutputStream)os).close();
                }
                if (is == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    public <T> List<T> importFromJson(File file, Class<T> clazz) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull(clazz);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            String jsonData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isNotBlank((String)jsonData) && !jsonData.equals(EMPTY_JSON)) {
                CollectionType type = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
                return (List)OBJECT_MAPPER.readValue(jsonData, (JavaType)type);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Collections.emptyList();
    }

    public <T> Optional<T> importObjectFromJson(File file, Class<T> clazz) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull(clazz);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            String jsonData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isNotBlank((String)jsonData) && !jsonData.equals(EMPTY_JSON)) {
                return Optional.of(OBJECT_MAPPER.readValue(jsonData, clazz));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Optional.empty();
    }

    private void writeEmptyJson(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(EMPTY_JSON);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

