/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.supportzip.SupportBundle;

public abstract class ContentSourceSupport
implements SupportBundle.ContentSource {
    public static final String PASSWORD_TOKEN = "****";
    public static final String EMAIL_TOKEN = "user@domain";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SupportBundle.ContentSource.Type type;
    private final String path;
    private SupportBundle.ContentSource.Priority priority = SupportBundle.ContentSource.Priority.DEFAULT;

    public ContentSourceSupport(SupportBundle.ContentSource.Type type, String path, SupportBundle.ContentSource.Priority priority) {
        this.type = (SupportBundle.ContentSource.Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.path = this.normalize((String)Preconditions.checkNotNull((Object)path));
        this.setPriority(priority);
    }

    public ContentSourceSupport(SupportBundle.ContentSource.Type type, String path) {
        this(type, path, SupportBundle.ContentSource.Priority.DEFAULT);
    }

    @Override
    public SupportBundle.ContentSource.Type getType() {
        return this.type;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public SupportBundle.ContentSource.Priority getPriority() {
        return this.priority;
    }

    public void setPriority(SupportBundle.ContentSource.Priority priority) {
        this.priority = (SupportBundle.ContentSource.Priority)((Object)Preconditions.checkNotNull((Object)((Object)priority)));
    }

    @Override
    public int compareTo(SupportBundle.ContentSource obj) {
        return Ints.compare((int)this.priority.order, (int)obj.getPriority().order);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "type=" + (Object)((Object)this.type) + ", path='" + this.path + '\'' + ", priority=" + (Object)((Object)this.priority) + '}';
    }

    private String normalize(String path) {
        return path.replace("\\", "/");
    }
}

