/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.text;

import java.util.Locale;

public final class UnitFormatter {
    public static String formatStorage(long bytes) {
        StoragePrefix prefix;
        if (bytes == 0L) {
            prefix = StoragePrefix.BYTE;
        } else {
            double exponent = Math.floor(Math.log10(Math.abs(bytes)));
            prefix = StoragePrefix.values()[(int)exponent / 3];
        }
        return String.format(Locale.ENGLISH, "%.2f %s", (double)bytes / prefix.value, prefix.name);
    }

    private static enum StoragePrefix {
        BYTE("B", Math.pow(10.0, 0.0)),
        KILO("KB", Math.pow(10.0, 3.0)),
        MEGA("MB", Math.pow(10.0, 6.0)),
        GIGA("GB", Math.pow(10.0, 9.0)),
        TERA("TB", Math.pow(10.0, 12.0)),
        PETA("PB", Math.pow(10.0, 15.0)),
        EXA("EB", Math.pow(10.0, 18.0));

        final String name;
        final double value;

        private StoragePrefix(String name, double value) {
            this.name = name;
            this.value = value;
        }
    }
}

