/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.stateguard;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.stateguard.MethodInvocationAction;
import org.sonatype.nexus.common.stateguard.StateGuard;
import org.sonatype.nexus.common.stateguard.StateGuardAware;
import org.sonatype.nexus.common.stateguard.Transition;
import org.sonatype.nexus.common.stateguard.Transitions;

public class TransitionsInterceptor
extends ComponentSupport
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Preconditions.checkNotNull((Object)invocation);
        Object target = invocation.getThis();
        Method method = invocation.getMethod();
        Preconditions.checkState((boolean)(target instanceof StateGuardAware), (String)"Invocation target (%s) does not implement: %s", target.getClass(), StateGuardAware.class);
        StateGuard states = ((StateGuardAware)target).getStateGuard();
        Preconditions.checkState((states != null ? 1 : 0) != 0);
        Transitions config = method.getAnnotation(Transitions.class);
        Preconditions.checkState((config != null ? 1 : 0) != 0);
        Transition transition = states.transition(config.to(), config.silent(), config.ignore());
        if (config.from() != null && config.from().length != 0) {
            transition = transition.from(config.from());
        }
        this.log.trace("Invoking: {} -> {}", (Object)transition, (Object)method);
        try {
            return transition.run(new MethodInvocationAction(invocation));
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

