/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.log;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class MarkedLogger
implements Logger {
    private final Logger delegate;
    private final Marker marker;

    public MarkedLogger(Logger delegate, Marker marker) {
        this.delegate = (Logger)Preconditions.checkNotNull((Object)delegate);
        this.marker = (Marker)Preconditions.checkNotNull((Object)marker);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.isTraceEnabled(this.marker);
    }

    public void trace(String msg) {
        this.trace(this.marker, msg);
    }

    public void trace(String format, Object arg) {
        this.trace(this.marker, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(this.marker, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.trace(this.marker, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.trace(this.marker, msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.delegate.trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.delegate.trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.delegate.trace(marker, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.delegate.trace(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled(this.marker);
    }

    public void debug(String msg) {
        this.debug(this.marker, msg);
    }

    public void debug(String format, Object arg) {
        this.debug(this.marker, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(this.marker, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.debug(this.marker, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.debug(this.marker, msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.delegate.debug(marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.delegate.debug(marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.debug(marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.delegate.debug(marker, format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.delegate.debug(marker, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isInfoEnabled(this.marker);
    }

    public void info(String msg) {
        this.info(this.marker, msg);
    }

    public void info(String format, Object arg) {
        this.info(this.marker, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(this.marker, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.info(this.marker, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.info(this.marker, msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.delegate.info(marker, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.delegate.info(marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.info(marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.delegate.info(marker, format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.delegate.info(marker, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isWarnEnabled(this.marker);
    }

    public void warn(String msg) {
        this.warn(this.marker, msg);
    }

    public void warn(String format, Object arg) {
        this.warn(this.marker, format, arg);
    }

    public void warn(String format, Object ... arguments) {
        this.warn(this.marker, format, arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(this.marker, format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.warn(this.marker, msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.delegate.warn(marker, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.delegate.warn(marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.warn(marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.delegate.warn(marker, format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.delegate.warn(marker, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isErrorEnabled(this.marker);
    }

    public void error(String msg) {
        this.error(this.marker, msg);
    }

    public void error(String format, Object arg) {
        this.error(this.marker, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(this.marker, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.error(this.marker, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.error(this.marker, msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.delegate.error(marker, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.delegate.error(marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.error(marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.delegate.error(marker, format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.delegate.error(marker, msg, t);
    }
}

