/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ExceptionSummarizer {
    private static final long ONE_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long ONE_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final long FIVE_SECONDS = 5L * ONE_SECOND;
    private final BiPredicate<Exception, Exception> matcher;
    private final BiConsumer<String, Exception> logger;
    @Nullable
    private Exception failureCause;
    private long firstFailureMillis;
    private long lastSummaryMillis;
    private int count;

    public static ExceptionSummarizer summarize(BiPredicate<Exception, Exception> matcher, BiConsumer<String, Exception> logger) {
        return new ExceptionSummarizer(matcher, logger);
    }

    public static BiPredicate<Exception, Exception> sameType() {
        return (lastFailure, failure) -> lastFailure != null && lastFailure.getClass().equals(failure.getClass());
    }

    public static BiPredicate<Exception, Exception> sameText() {
        return (lastFailure, failure) -> lastFailure != null && lastFailure.toString().equals(failure.toString());
    }

    public static BiConsumer<String, Exception> warn(Logger logger) {
        return (message, failure) -> logger.warn(message, (Throwable)failure);
    }

    public static BiConsumer<String, Exception> info(Logger logger) {
        return (message, failure) -> logger.info(message, (Throwable)failure);
    }

    @VisibleForTesting
    ExceptionSummarizer(BiPredicate<Exception, Exception> matcher, BiConsumer<String, Exception> logger) {
        this.matcher = (BiPredicate)Preconditions.checkNotNull(matcher);
        this.logger = (BiConsumer)Preconditions.checkNotNull(logger);
    }

    public synchronized void log(String message, Exception cause) {
        ++this.count;
        long now = this.currentTimeMillis();
        if (!this.matcher.test(this.failureCause, cause) || now - this.firstFailureMillis >= ONE_MINUTE) {
            this.logger.accept(message, cause);
            this.failureCause = cause;
            this.firstFailureMillis = now;
            this.lastSummaryMillis = now;
            this.count = 0;
        } else if (now - this.lastSummaryMillis >= FIVE_SECONDS) {
            String summary = String.format("%s: %s - occurred %d times in last %d seconds", message, cause, this.count, (now - this.lastSummaryMillis) / ONE_SECOND);
            this.logger.accept(summary, null);
            this.lastSummaryMillis = now;
            this.count = 0;
        }
    }

    @VisibleForTesting
    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

