/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SanitizingJsonOutputStream
extends PipedOutputStream {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonGenerator generator;
    private final Thread pipe;
    private IOException ioException;

    public SanitizingJsonOutputStream(OutputStream out, Collection<String> fields, String replacement) throws IOException {
        this.generator = new SanitizingJsonGenerator(jsonFactory.createGenerator(out), fields, replacement);
        PipedInputStream pipedInput = new PipedInputStream(this);
        this.pipe = new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JsonParser parser = jsonFactory.createParser((InputStream)pipedInput);){
                    parser.nextToken();
                    this.generator.copyCurrentStructure(parser);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.ioException = e;
            }
        });
        this.pipe.start();
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            try {
                this.pipe.join();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.generator.close();
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
    }

    private static class SanitizingJsonGenerator
    extends JsonGeneratorDelegate {
        private final Set<String> fields;
        private final String replacement;
        private int skip;

        public SanitizingJsonGenerator(JsonGenerator delegate, Collection<String> fields, String replacement) {
            super(delegate, false);
            this.fields = new HashSet<String>(fields);
            this.replacement = (String)Preconditions.checkNotNull((Object)replacement);
        }

        public void copyCurrentStructure(JsonParser jp) throws IOException {
            if (jp.hasTokenId(5) && this.fields.contains(jp.getCurrentName())) {
                ++this.skip;
                super.copyCurrentStructure(jp);
                --this.skip;
            } else {
                super.copyCurrentStructure(jp);
            }
        }

        public void copyCurrentEvent(JsonParser jp) throws IOException {
            boolean shouldReplace;
            boolean bl = shouldReplace = this.skip > 0 && !jp.getText().isEmpty();
            if (shouldReplace) {
                this.writeString(this.replacement);
            } else {
                super.copyCurrentEvent(jp);
            }
        }

        protected void _copyCurrentContents(JsonParser p) throws IOException {
            JsonToken t;
            int depth = 1;
            boolean replaceNext = false;
            while ((t = p.nextToken()) != null) {
                switch (t.id()) {
                    case 5: {
                        if (this.fields.contains(p.getCurrentName())) {
                            replaceNext = true;
                        }
                        this.writeFieldName(p.getCurrentName());
                        break;
                    }
                    case 3: {
                        this.writeStartArray();
                        replaceNext = false;
                        ++depth;
                        break;
                    }
                    case 1: {
                        this.writeStartObject();
                        replaceNext = false;
                        ++depth;
                        break;
                    }
                    case 4: {
                        this.writeEndArray();
                        if (--depth != 0) break;
                        return;
                    }
                    case 2: {
                        this.writeEndObject();
                        if (--depth != 0) break;
                        return;
                    }
                    case 6: {
                        if (replaceNext && !p.getText().isEmpty()) {
                            this.writeString(this.replacement);
                            break;
                        }
                        if (p.hasTextCharacters()) {
                            this.writeString(p.getTextCharacters(), p.getTextOffset(), p.getTextLength());
                            break;
                        }
                        this.writeString(p.getText());
                        break;
                    }
                    case 7: {
                        JsonParser.NumberType n = p.getNumberType();
                        if (n == JsonParser.NumberType.INT) {
                            this.writeNumber(p.getIntValue());
                            break;
                        }
                        if (n == JsonParser.NumberType.BIG_INTEGER) {
                            this.writeNumber(p.getBigIntegerValue());
                            break;
                        }
                        this.writeNumber(p.getLongValue());
                        break;
                    }
                    case 8: {
                        JsonParser.NumberType n = p.getNumberType();
                        if (n == JsonParser.NumberType.BIG_DECIMAL) {
                            this.writeNumber(p.getDecimalValue());
                            break;
                        }
                        if (n == JsonParser.NumberType.FLOAT) {
                            this.writeNumber(p.getFloatValue());
                            break;
                        }
                        this.writeNumber(p.getDoubleValue());
                        break;
                    }
                    case 9: {
                        this.writeBoolean(true);
                        break;
                    }
                    case 10: {
                        this.writeBoolean(false);
                        break;
                    }
                    case 11: {
                        this.writeNull();
                        break;
                    }
                    case 12: {
                        this.writeObject(p.getEmbeddedObject());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Internal error: unknown current token, " + t);
                    }
                }
                if (!replaceNext) continue;
                this.consume(p);
                replaceNext = false;
            }
        }

        private void consume(JsonParser p) throws IOException {
            JsonToken t;
            int depth = 1;
            int skip = 0;
            while (skip >= 0 && (t = p.nextToken()) != null) {
                switch (t.id()) {
                    case 5: {
                        this.writeFieldName(p.getCurrentName());
                        ++skip;
                        break;
                    }
                    case 3: {
                        this.writeStartArray();
                        ++depth;
                        break;
                    }
                    case 1: {
                        this.writeStartObject();
                        ++depth;
                        break;
                    }
                    case 4: {
                        this.writeEndArray();
                        if (--depth == 0) {
                            return;
                        }
                        --skip;
                        break;
                    }
                    case 2: {
                        this.writeEndObject();
                        if (--depth == 0) {
                            return;
                        }
                        --skip;
                        break;
                    }
                    case 11: {
                        this.writeNull();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        if (!p.getText().isEmpty()) {
                            this.writeString(this.replacement);
                        } else {
                            this.writeString(p.getText());
                        }
                        --skip;
                        break;
                    }
                    case 12: {
                        this.writeObject(p.getEmbeddedObject());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Internal error: unknown current token, " + t);
                    }
                }
            }
        }
    }
}

