/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class SafeXml {
    private static final String APACHE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String APACHE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String XML_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String XML_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

    private SafeXml() {
    }

    public static XMLInputFactory newXmlInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlInputFactory;
    }

    public static DocumentBuilderFactory newdocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature(APACHE_DISALLOW_DOCTYPE_DECL, false);
        factory.setFeature(APACHE_LOAD_EXTERNAL_DTD, false);
        factory.setFeature(XML_EXTERNAL_GENERAL_ENTITIES, false);
        factory.setFeature(XML_EXTERNAL_PARAMETER_ENTITIES, false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        return factory;
    }

    public static DocumentBuilderFactory newStrictDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = SafeXml.newdocumentBuilderFactory();
        factory.setFeature(APACHE_DISALLOW_DOCTYPE_DECL, true);
        return factory;
    }

    public static TransformerFactory newTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }

    public static SAXTransformerFactory newSaxTransformerFactory() {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }

    public static SAXParserFactory newSaxParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature(APACHE_LOAD_EXTERNAL_DTD, false);
        factory.setFeature(XML_EXTERNAL_GENERAL_ENTITIES, false);
        factory.setFeature(XML_EXTERNAL_PARAMETER_ENTITIES, false);
        return factory;
    }

    public static SAXParserFactory newStrictSaxParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SafeXml.newSaxParserFactory();
        factory.setFeature(APACHE_DISALLOW_DOCTYPE_DECL, true);
        return factory;
    }

    public static void configureValidator(Validator validator) throws SAXNotRecognizedException, SAXNotSupportedException {
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }
}

