/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonatype.nexus.common.hash.HashAlgorithm;

public class MultiHashingInputStream
extends FilterInputStream {
    private final Map<HashAlgorithm, Hasher> hashers = new LinkedHashMap<HashAlgorithm, Hasher>();
    private long count;

    public MultiHashingInputStream(Iterable<HashAlgorithm> algorithms, InputStream inputStream) {
        super((InputStream)Preconditions.checkNotNull((Object)inputStream));
        Preconditions.checkNotNull(algorithms);
        for (HashAlgorithm algorithm : algorithms) {
            this.hashers.put(algorithm, algorithm.function().newHasher());
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            for (Hasher hasher : this.hashers.values()) {
                hasher.putByte((byte)b);
            }
            ++this.count;
        }
        return b;
    }

    @Override
    public int read(@Nonnull byte[] bytes, int off, int len) throws IOException {
        int numRead = this.in.read(bytes, off, len);
        if (numRead != -1) {
            for (Hasher hasher : this.hashers.values()) {
                hasher.putBytes(bytes, off, numRead);
            }
            this.count += (long)numRead;
        }
        return numRead;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public Map<HashAlgorithm, HashCode> hashes() {
        HashMap<HashAlgorithm, HashCode> hashes = new HashMap<HashAlgorithm, HashCode>(this.hashers.size());
        for (Map.Entry<HashAlgorithm, Hasher> entry : this.hashers.entrySet()) {
            hashes.put(entry.getKey(), entry.getValue().hash());
        }
        return hashes;
    }

    public long count() {
        return this.count;
    }
}

