/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Map;
import java.util.Optional;

public class HashAlgorithm {
    public static final HashAlgorithm MD5 = new HashAlgorithm("md5", Hashing.md5());
    public static final HashAlgorithm SHA1 = new HashAlgorithm("sha1", Hashing.sha1());
    public static final HashAlgorithm SHA256 = new HashAlgorithm("sha256", Hashing.sha256());
    public static final HashAlgorithm SHA512 = new HashAlgorithm("sha512", Hashing.sha512());
    public static final Map<String, HashAlgorithm> ALL_HASH_ALGORITHMS = ImmutableMap.of((Object)HashAlgorithm.MD5.name, (Object)MD5, (Object)HashAlgorithm.SHA1.name, (Object)SHA1, (Object)HashAlgorithm.SHA256.name, (Object)SHA256, (Object)HashAlgorithm.SHA512.name, (Object)SHA512);
    private final String name;
    private final HashFunction function;

    public HashAlgorithm(String name, HashFunction function) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.function = (HashFunction)Preconditions.checkNotNull((Object)function);
    }

    public String name() {
        return this.name;
    }

    public HashFunction function() {
        return this.function;
    }

    public static Optional<HashAlgorithm> getHashAlgorithm(String algorithm) {
        return Optional.ofNullable(ALL_HASH_ALGORITHMS.get(algorithm));
    }
}

