/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.guice;

import com.google.inject.TypeLiteral;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.inject.Named;
import org.sonatype.nexus.common.guice.TypeConverterSupport;

@Named
public class DurationTypeConverter
extends TypeConverterSupport<Duration> {
    private static final ParseConfig[] PARSE_CONFIGS = new ParseConfig[]{new ParseConfig(ChronoUnit.SECONDS, new String[]{"seconds", "second", "sec", "s"}), new ParseConfig(ChronoUnit.MINUTES, new String[]{"minutes", "minute", "min", "m"}), new ParseConfig(ChronoUnit.HOURS, new String[]{"hours", "hour", "hr", "h"}), new ParseConfig(ChronoUnit.DAYS, new String[]{"days", "day", "d"}), new ParseConfig(ChronoUnit.MILLIS, new String[]{"milliseconds", "millisecond", "millis", "ms"}), new ParseConfig(ChronoUnit.NANOS, new String[]{"nanoseconds", "nanosecond", "nanos", "ns"}), new ParseConfig(ChronoUnit.MICROS, new String[]{"microseconds", "microsecond", "micros", "us"})};

    @Override
    protected Object doConvert(String value, TypeLiteral<?> toType) throws Exception {
        if (value != null) {
            return DurationTypeConverter.doParse(value.trim().toLowerCase());
        }
        return null;
    }

    private static Duration doParse(String value) {
        ParseConfig[] parseConfigArray = PARSE_CONFIGS;
        int n = PARSE_CONFIGS.length;
        int n2 = 0;
        while (n2 < n) {
            ParseConfig config = parseConfigArray[n2];
            Duration t = DurationTypeConverter.extract(value, config.unit, config.suffixes);
            if (t != null) {
                return t;
            }
            ++n2;
        }
        throw new RuntimeException("Unable to parse: " + value);
    }

    private static Duration extract(String value, ChronoUnit unit, String ... suffixes) {
        String number = null;
        String units = null;
        int p = 0;
        while (p < value.length()) {
            if (!Character.isDigit(value.charAt(p))) {
                number = value.substring(0, p);
                units = value.substring(p, value.length()).trim();
                break;
            }
            ++p;
        }
        if (units != null) {
            String[] stringArray = suffixes;
            int n = suffixes.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (suffix.equals(units)) {
                    long n3 = Long.parseLong(number.trim());
                    return Duration.of(n3, unit);
                }
                ++n2;
            }
        }
        return null;
    }

    private static class ParseConfig {
        final ChronoUnit unit;
        final String[] suffixes;

        private ParseConfig(ChronoUnit unit, String ... suffixes) {
            this.unit = unit;
            this.suffixes = suffixes;
        }
    }
}

