/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.DetachedEntityMetadata;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.entity.EntityVersion;

public class EntityHelper {
    private EntityHelper() {
    }

    public static boolean hasMetadata(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        return entity.getEntityMetadata() != null;
    }

    @Nonnull
    public static EntityMetadata metadata(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        EntityMetadata metadata = entity.getEntityMetadata();
        Preconditions.checkState((metadata != null ? 1 : 0) != 0, (Object)"Missing entity-metadata");
        return metadata;
    }

    public static boolean isDetached(Entity entity) {
        return EntityHelper.metadata(entity) instanceof DetachedEntityMetadata;
    }

    @Nonnull
    public static EntityId id(Entity entity) {
        EntityId id = EntityHelper.metadata(entity).getId();
        Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"Missing entity-id");
        return id;
    }

    @Nonnull
    public static EntityId id(String id) {
        return new DetachedEntityId(id);
    }

    @Nonnull
    public static EntityVersion version(Entity entity) {
        EntityVersion version = EntityHelper.metadata(entity).getVersion();
        Preconditions.checkState((version != null ? 1 : 0) != 0, (Object)"Missing entity-version");
        return version;
    }

    public static void clearMetadata(Object entity) {
        if (entity instanceof Entity) {
            ((Entity)entity).setEntityMetadata(null);
        }
    }
}

