/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.entity.EntityVersion;
import org.sonatype.nexus.common.event.HasAffinity;
import org.sonatype.nexus.common.event.HasLocality;

public abstract class EntityEvent
implements HasAffinity,
HasLocality {
    private final EntityMetadata metadata;
    private String remoteNodeId;
    private String affinity;
    private volatile Entity entity;

    public EntityEvent(EntityMetadata metadata) {
        this.metadata = (EntityMetadata)Preconditions.checkNotNull((Object)metadata);
    }

    public EntityId getId() {
        return this.metadata.getId();
    }

    public EntityVersion getVersion() {
        return this.metadata.getVersion();
    }

    @Override
    public boolean isLocal() {
        return this.remoteNodeId == null;
    }

    public void setRemoteNodeId(@Nullable String remoteNodeId) {
        this.remoteNodeId = remoteNodeId;
    }

    @Nullable
    public String getRemoteNodeId() {
        return this.remoteNodeId;
    }

    @Nullable
    public <T extends Entity> Class<T> getEntityType() {
        return this.metadata.getEntityType().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends Entity> T getEntity() {
        if (this.entity == null) {
            EntityEvent entityEvent = this;
            synchronized (entityEvent) {
                if (this.entity == null) {
                    this.entity = this.metadata.getEntity().orElse(null);
                }
            }
        }
        return (T)this.entity;
    }

    @Override
    public String getAffinity() {
        return this.affinity;
    }

    public void setAffinity(String affinity) {
        this.affinity = affinity;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "metadata=" + this.metadata + ", remoteNodeId=" + this.remoteNodeId + '}';
    }
}

