/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.cooperation2.internal.orient;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.cooperation2.internal.DisabledCooperation2;
import org.sonatype.nexus.common.cooperation2.internal.MutableConfigSupport;
import org.sonatype.nexus.common.cooperation2.internal.orient.OrientCooperation2;
import org.sonatype.nexus.common.io.CooperationFactory;

@Named
@Singleton
public class OrientCooperation2Factory
extends ComponentSupport
implements Cooperation2Factory {
    private CooperationFactory cooperationFactory;

    @Inject
    public OrientCooperation2Factory(CooperationFactory cooperationFactory) {
        this.cooperationFactory = cooperationFactory;
    }

    @Override
    public Cooperation2Factory.Builder configure() {
        return new DefaultCooperation2Builder();
    }

    protected class DefaultCooperation2Builder
    extends MutableConfigSupport {
        protected DefaultCooperation2Builder() {
        }

        @Override
        public Cooperation2 build(String id) {
            if (!this.enabled) {
                OrientCooperation2Factory.this.log.debug("Disabled cooperation: {}", (Object)id);
                return new DisabledCooperation2(id);
            }
            return new OrientCooperation2(OrientCooperation2Factory.this.cooperationFactory.configure().majorTimeout(this.majorTimeout()).minorTimeout(this.minorTimeout()).threadsPerKey(this.threadsPerKey).build(id));
        }
    }
}

