/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.transaction;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.tx.OTransaction;
import org.sonatype.nexus.transaction.RetryController;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.TransactionalSession;
import org.sonatype.nexus.transaction.UnitOfWork;

public class OrientTransaction
implements TransactionalSession<OrientTransaction>,
Transaction {
    private final ODatabaseDocumentTx db;
    private int retries = 0;
    private String reason = "transaction";

    OrientTransaction(ODatabaseDocumentTx db) {
        this.db = (ODatabaseDocumentTx)Preconditions.checkNotNull((Object)db);
    }

    public ODatabaseDocumentTx getDb() {
        return this.db;
    }

    public static ODatabaseDocumentTx currentDb() {
        Transaction tx = UnitOfWork.currentTx();
        if (tx instanceof OrientTransaction) {
            return ((OrientTransaction)tx).db;
        }
        try {
            return (ODatabaseDocumentTx)tx.getClass().getMethod("getDb", new Class[0]).invoke((Object)tx, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Transaction " + tx + " has no public 'getDb' method", e);
        }
    }

    public void begin() {
        this.db.begin();
    }

    public void commit() {
        this.db.commit();
        this.retries = 0;
    }

    public void rollback() {
        this.db.rollback();
    }

    public void close() {
        this.db.close();
    }

    public boolean isActive() {
        OTransaction tx = null;
        if (this.db.isActiveOnCurrentThread()) {
            tx = this.db.getTransaction();
        }
        return tx != null && tx.isActive();
    }

    public boolean allowRetry(Exception cause) {
        if (RetryController.INSTANCE.allowRetry(this.retries, cause)) {
            ++this.retries;
            return true;
        }
        return false;
    }

    public void reason(String reason) {
        this.reason = (String)Preconditions.checkNotNull((Object)reason);
    }

    public String reason() {
        return this.reason;
    }

    public OrientTransaction getTransaction() {
        return this;
    }
}

