/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.orientechnologies.common.exception.OHighLevelException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public final class EntityLog {
    @VisibleForTesting
    static final String ENTITY_LOG_LIMIT_KEY = "nexus.orient.entityLog.limit";
    private final int entityLogLimit = SystemPropertiesHelper.getInteger((String)"nexus.orient.entityLog.limit", (int)1000);
    private final boolean hasRecordIds = OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getValueAsBoolean();
    private final Provider<DatabaseInstance> databaseProvider;
    private final List<EntityAdapter> adapters;
    private OLocalPaginatedStorage storage;

    public EntityLog(Provider<DatabaseInstance> databaseProvider, EntityAdapter ... adapters) {
        this.databaseProvider = (Provider)Preconditions.checkNotNull(databaseProvider);
        this.adapters = Arrays.asList(adapters);
    }

    public OLogSequenceNumber mark() {
        return this.storage().getWALInstance().end();
    }

    public Map<ORID, EntityAdapter> since(OLogSequenceNumber marker) {
        Preconditions.checkNotNull((Object)marker);
        return (Map)this.storage().callInLock(() -> {
            try {
                return this.doSince(marker);
            }
            catch (Exception e) {
                throw new UnknownDeltaException(marker, (Throwable)e);
            }
        }, false);
    }

    private OLocalPaginatedStorage storage() {
        if (this.storage == null || this.storage.isClosed()) {
            ODatabaseDocumentInternal currentDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseProvider.get()).acquire();){
                    this.storage = (OLocalPaginatedStorage)db.getStorage().getUnderlying();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                ODatabaseRecordThreadLocal.instance().set(currentDb);
            }
        }
        return this.storage;
    }

    private Map<ORID, EntityAdapter> doSince(OLogSequenceNumber marker) throws IOException {
        OWriteAheadLog wal = this.storage.getWALInstance();
        OLogSequenceNumber end = wal.end();
        if (marker.equals((Object)end)) {
            return ImmutableMap.of();
        }
        Preconditions.checkArgument((marker.compareTo(end) <= 0 ? 1 : 0) != 0, (Object)"Sequence number cannot be after end");
        OLogSequenceNumber firstChange = (OLogSequenceNumber)Preconditions.checkNotNull((Object)wal.next(marker), (Object)"Dangling sequence number");
        AdapterIndex adapterIndex = new AdapterIndex(this.adapters);
        wal.addCutTillLimit(firstChange);
        try {
            HashMap<ORID, EntityAdapter> result = new HashMap<ORID, EntityAdapter>();
            OLogSequenceNumber lsn = (OLogSequenceNumber)Preconditions.checkNotNull((Object)wal.next(marker), (Object)"Dangling sequence number");
            while (lsn != null && lsn.compareTo(end) <= 0) {
                OWALRecord record = wal.read(lsn);
                if (record instanceof OAtomicUnitEndRecord) {
                    this.extractDelta((OAtomicUnitEndRecord)record).forEach(rid -> {
                        EntityAdapter entityAdapter = result.computeIfAbsent((ORID)rid, adapterIndex::lookup);
                    });
                    if (this.entityLogLimit >= 0 && result.size() > this.entityLogLimit) {
                        throw new IOException("Too many changes to return");
                    }
                }
                lsn = wal.next(lsn);
            }
            HashMap<ORID, EntityAdapter> hashMap = result;
            return hashMap;
        }
        finally {
            wal.removeCutTillLimit(firstChange);
        }
    }

    private Set<ORID> extractDelta(OAtomicUnitEndRecord record) {
        OAtomicOperationMetadata ops = (OAtomicOperationMetadata)record.getAtomicOperationMetadata().get("rid");
        if (ops instanceof ORecordOperationMetadata) {
            return ((ORecordOperationMetadata)ops).getValue();
        }
        Preconditions.checkState((boolean)this.hasRecordIds, (Object)"Record ids not available");
        return ImmutableSet.of();
    }

    private static class AdapterIndex {
        private final Map<Integer, EntityAdapter> index = new HashMap<Integer, EntityAdapter>();

        public AdapterIndex(List<EntityAdapter> adapters) {
            adapters.forEach(adapter -> {
                int[] nArray = adapter.getSchemaType().getClusterIds();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int clusterId = nArray[n2];
                    this.index.put(clusterId, (EntityAdapter)((Object)adapter));
                    ++n2;
                }
            });
        }

        public EntityAdapter lookup(ORID rid) {
            return this.index.get(rid.getClusterId());
        }
    }

    public static class UnknownDeltaException
    extends RuntimeException
    implements OHighLevelException {
        public UnknownDeltaException(OLogSequenceNumber since, Throwable cause) {
            super(String.format("Changes exist since %s but details are not available", since), cause);
        }

        public UnknownDeltaException(String message) {
            super(message);
        }
    }
}

