/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.primitives.Longs;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.ConflictState;
import org.sonatype.nexus.orient.entity.DeconflictStep;

public abstract class DeconflictStepSupport<T extends Entity>
extends ComponentSupport
implements DeconflictStep<T> {
    private static final Comparator<Long> MILLIS_COMPARATOR = Comparator.nullsFirst(Comparator.naturalOrder());

    public static ConflictState pickNonNull(ODocument storedRecord, ODocument changeRecord, String fieldName) {
        Object changeValue;
        Object storedValue = storedRecord.rawField(fieldName);
        if (Objects.equals(storedValue, changeValue = changeRecord.rawField(fieldName))) {
            return ConflictState.IGNORE;
        }
        if (storedValue == null) {
            storedRecord.field(fieldName, changeValue);
            return ConflictState.ALLOW;
        }
        if (changeValue == null) {
            changeRecord.field(fieldName, storedValue);
            return ConflictState.MERGE;
        }
        return ConflictState.DENY;
    }

    public static ConflictState pickLatest(ODocument storedRecord, ODocument changeRecord, String fieldName) {
        Object storedValue = storedRecord.rawField(fieldName);
        Object changeValue = changeRecord.rawField(fieldName);
        int comparison = MILLIS_COMPARATOR.compare(DeconflictStepSupport.asMillis(storedValue), DeconflictStepSupport.asMillis(changeValue));
        if (comparison < 0) {
            storedRecord.field(fieldName, changeValue);
            return ConflictState.ALLOW;
        }
        if (comparison > 0) {
            changeRecord.field(fieldName, storedValue);
            return ConflictState.MERGE;
        }
        return ConflictState.IGNORE;
    }

    @Nullable
    private static Long asMillis(@Nullable Object value) {
        Long time = null;
        if (value instanceof Date) {
            time = ((Date)value).getTime();
        } else if (value instanceof Number) {
            time = ((Number)value).longValue();
        } else if (value instanceof String) {
            time = Longs.tryParse((String)((String)value));
        }
        return time;
    }
}

