/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;

public class ExplainODatabaseDocumentTx
extends ODatabaseDocumentTx {
    private Logger log;

    public ExplainODatabaseDocumentTx(String url, Logger log) {
        super(url, false);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
    }

    public OCommandRequest command(OCommandRequest command) {
        final OCommandRequest request = super.command(command);
        if (this.log.isTraceEnabled() && (request instanceof OCommandSQL || request instanceof OSQLSynchQuery)) {
            final String sql = ((OCommandRequestText)request).getText();
            return (OCommandRequest)Proxy.newProxyInstance(OCommandRequest.class.getClassLoader(), new Class[]{OCommandRequest.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (!"execute".equals(method.getName())) {
                        return method.invoke((Object)request, args);
                    }
                    request.getContext().setRecordingMetrics(true);
                    long startTime = System.nanoTime();
                    Object result = method.invoke((Object)request, args);
                    long stopTime = System.nanoTime();
                    ODocument report = new ODocument(request.getContext().getVariables());
                    report.field("elapsed", (Object)Float.valueOf((float)(stopTime - startTime) / 1000000.0f));
                    ExplainODatabaseDocumentTx.this.log.debug("\n{}\n{}\n", (Object)sql, (Object)report.toJSON("prettyPrint"));
                    request.getContext().setRecordingMetrics(false);
                    return result;
                }
            });
        }
        return request;
    }
}

