/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OStorage;
import java.lang.reflect.Field;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.goodies.lifecycle.Lifecycles;
import org.sonatype.nexus.orient.DatabasePool;

public abstract class DatabasePoolSupport
extends LifecycleSupport
implements DatabasePool {
    private final String name;
    private static final Field partitionsField;
    private static final Field partitionQueueField;

    static {
        Field _partitionQueueField;
        Field _partitionsField;
        try {
            _partitionsField = OPartitionedDatabasePool.class.getDeclaredField("partitions");
            _partitionQueueField = _partitionsField.getType().getComponentType().getDeclaredField("queue");
            _partitionsField.setAccessible(true);
            _partitionQueueField.setAccessible(true);
        }
        catch (Exception | LinkageError e) {
            LoggerFactory.getLogger(DatabasePoolSupport.class).warn("Problem introspecting OPartitionedDatabasePool", e);
            _partitionsField = null;
            _partitionQueueField = null;
        }
        partitionsField = _partitionsField;
        partitionQueueField = _partitionQueueField;
    }

    public DatabasePoolSupport(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return super.isStarted();
    }

    @Override
    public void close() {
        Lifecycles.stop((Lifecycle)this);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + '}';
    }

    @Deprecated
    public abstract void replaceStorage(OStorage var1);

    protected void replaceStorage(OPartitionedDatabasePool pool, OStorage storage) {
        if (partitionsField != null) {
            ODatabaseDocumentInternal originalDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
            try {
                try {
                    Object[] objectArray = (Object[])partitionsField.get(pool);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object partition = objectArray[n2];
                        for (ODatabaseDocumentTx db : (Iterable)partitionQueueField.get(partition)) {
                            this.replaceStorage(db, storage);
                        }
                        ++n2;
                    }
                }
                catch (Exception | LinkageError e) {
                    this.log.warn("Problem replacing storage for {}", (Object)storage.getName(), (Object)e);
                    ODatabaseRecordThreadLocal.instance().set(originalDb);
                }
            }
            finally {
                ODatabaseRecordThreadLocal.instance().set(originalDb);
            }
        }
    }

    private void replaceStorage(ODatabaseDocumentTx db, OStorage storage) {
        db.replaceStorage(storage);
        if (!db.isClosed()) {
            try {
                if (db.getMetadata().getSchema().countClasses() == 0) {
                    this.log.debug("Reloading metadata for {} as storage has changed", (Object)db.getName());
                    db.activateOnCurrentThread();
                    db.getMetadata().reload();
                }
            }
            catch (Exception e) {
                this.log.warn("Problem reloading metadata for {}", (Object)db.getName(), (Object)e);
            }
        }
    }
}

