/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.DatabaseExternalizer;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabasePool;

public class DatabaseInstanceImpl
extends ComponentSupport
implements DatabaseInstance {
    private final DatabaseManager databaseManager;
    private final String name;
    private volatile DatabasePool pool;

    public DatabaseInstanceImpl(DatabaseManager databaseManager, String name) {
        this.databaseManager = (DatabaseManager)Preconditions.checkNotNull((Object)databaseManager);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ODatabaseDocumentTx connect() {
        return this.databaseManager.connect(this.name, false);
    }

    @Override
    public ODatabaseDocumentTx acquire() {
        return this.pool().acquire();
    }

    @Override
    public DatabaseExternalizer externalizer() {
        return this.databaseManager.externalizer(this.name);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + '}';
    }

    @Override
    public void setFrozen(boolean frozen) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = this.connect();){
            if (frozen) {
                db.freeze(true);
            } else {
                db.release();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isFrozen() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = this.connect();){
            return db.isFrozen();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void releasePool() {
        this.pool = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabasePool pool() {
        if (this.pool == null) {
            DatabaseInstanceImpl databaseInstanceImpl = this;
            synchronized (databaseInstanceImpl) {
                if (this.pool == null) {
                    this.pool = this.databaseManager.pool(this.name);
                }
            }
        }
        return this.pool;
    }
}

