/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="config", from="1.7", to="1.8")
public class ConfigDatabaseUpgrade_1_8
extends DatabaseUpgradeSupport {
    private static final String REPOSITORY_CLASS_NAME = new OClassNameBuilder().type("repository").build();
    private static final String RID = "@rid";
    private static final String ATTRIBUTES_CLEANUP_POLICY_NAME = "attributes.cleanup.policyName";
    private static final String UPDATE_REPOSITORY = "UPDATE repository SET attributes.cleanup.policyName = set('%s') WHERE @rid = %s";
    private final Provider<DatabaseInstance> databaseInstance;

    @Inject
    public ConfigDatabaseUpgrade_1_8(@Named(value="config") Provider<DatabaseInstance> databaseInstance) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
    }

    public void apply() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.getRepositoriesWithACleanupPolicy(db).forEach(repository -> db.command((OCommandRequest)new OCommandSQL(String.format(UPDATE_REPOSITORY, repository.field(ATTRIBUTES_CLEANUP_POLICY_NAME), repository.field(RID)))).execute(new Object[0]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stream<ODocument> getRepositoriesWithACleanupPolicy(ODatabaseDocumentTx db) {
        return StreamSupport.stream(db.browseClass(REPOSITORY_CLASS_NAME).spliterator(), false).filter(result -> Objects.nonNull(result.field(ATTRIBUTES_CLEANUP_POLICY_NAME)));
    }
}

