/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.1", to="1.2")
public class ComponentDatabaseUpgrade_1_2
extends DatabaseUpgradeSupport {
    static final String COMPONENT_CLASS = new OClassNameBuilder().type("component").build();
    static final String I_BUCKET_NAME_VERSION = new OIndexNameBuilder().type(COMPONENT_CLASS).property("bucket").property("name").property("version").build();
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_2(@Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        this.createBucketNameIndex();
    }

    private void createBucketNameIndex() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
            OSchemaProxy schema;
            OClass type;
            if (db.getMetadata().getIndexManager().getIndex(I_BUCKET_NAME_VERSION) == null && (type = (schema = db.getMetadata().getSchema()).getClass(COMPONENT_CLASS)) != null) {
                type.createIndex(I_BUCKET_NAME_VERSION, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"bucket", "name", "version"});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

